/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.Sources;

@Experimental
@Immutable
public interface SettingsBuilderRequest
extends Request<ProtoSession> {
    @Nonnull
    public Optional<Source> getInstallationSettingsSource();

    @Nonnull
    public Optional<Source> getProjectSettingsSource();

    @Nonnull
    public Optional<Source> getUserSettingsSource();

    @Nonnull
    public Optional<UnaryOperator<String>> getInterpolationSource();

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull ProtoSession session, @Nonnull Source installationSettingsSource, @Nonnull Source userSettingsSource) {
        return SettingsBuilderRequest.build(session, installationSettingsSource, null, userSettingsSource);
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull ProtoSession session, @Nonnull Path installationSettingsPath, @Nonnull Path userSettingsPath) {
        return SettingsBuilderRequest.build(session, Sources.fromPath(installationSettingsPath), null, Sources.fromPath(userSettingsPath));
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull ProtoSession session, @Nullable Source installationSettingsSource, @Nullable Source projectSettingsSource, @Nullable Source userSettingsSource) {
        return SettingsBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).installationSettingsSource(installationSettingsSource).projectSettingsSource(projectSettingsSource).userSettingsSource(userSettingsSource).build();
    }

    @Nonnull
    public static SettingsBuilderRequest build(@Nonnull ProtoSession session, @Nullable Path installationSettingsPath, @Nullable Path projectSettingsPath, @Nullable Path userSettingsPath) {
        return SettingsBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).installationSettingsSource(installationSettingsPath != null && Files.exists(installationSettingsPath, new LinkOption[0]) ? Sources.fromPath(installationSettingsPath) : null).projectSettingsSource(projectSettingsPath != null && Files.exists(projectSettingsPath, new LinkOption[0]) ? Sources.fromPath(projectSettingsPath) : null).userSettingsSource(userSettingsPath != null && Files.exists(userSettingsPath, new LinkOption[0]) ? Sources.fromPath(userSettingsPath) : null).build();
    }

    @Nonnull
    public static SettingsBuilderRequestBuilder builder() {
        return new SettingsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class SettingsBuilderRequestBuilder {
        ProtoSession session;
        RequestTrace trace;
        Source installationSettingsSource;
        Source projectSettingsSource;
        Source userSettingsSource;
        UnaryOperator<String> interpolationSource;

        public SettingsBuilderRequestBuilder session(ProtoSession session) {
            this.session = session;
            return this;
        }

        public SettingsBuilderRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public SettingsBuilderRequestBuilder installationSettingsSource(Source installationSettingsSource) {
            this.installationSettingsSource = installationSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder projectSettingsSource(Source projectSettingsSource) {
            this.projectSettingsSource = projectSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder userSettingsSource(Source userSettingsSource) {
            this.userSettingsSource = userSettingsSource;
            return this;
        }

        public SettingsBuilderRequestBuilder interpolationSource(UnaryOperator<String> interpolationSource) {
            this.interpolationSource = interpolationSource;
            return this;
        }

        public SettingsBuilderRequest build() {
            return new DefaultSettingsBuilderRequest(this.session, this.trace, this.installationSettingsSource, this.projectSettingsSource, this.userSettingsSource, this.interpolationSource);
        }

        private static class DefaultSettingsBuilderRequest
        extends BaseRequest<ProtoSession>
        implements SettingsBuilderRequest {
            private final Source installationSettingsSource;
            private final Source projectSettingsSource;
            private final Source userSettingsSource;
            private final UnaryOperator<String> interpolationSource;

            DefaultSettingsBuilderRequest(@Nonnull ProtoSession session, @Nullable RequestTrace trace, @Nullable Source installationSettingsSource, @Nullable Source projectSettingsSource, @Nullable Source userSettingsSource, @Nullable UnaryOperator<String> interpolationSource) {
                super(session, trace);
                this.installationSettingsSource = installationSettingsSource;
                this.projectSettingsSource = projectSettingsSource;
                this.userSettingsSource = userSettingsSource;
                this.interpolationSource = interpolationSource;
            }

            @Override
            @Nonnull
            public Optional<Source> getInstallationSettingsSource() {
                return Optional.ofNullable(this.installationSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getProjectSettingsSource() {
                return Optional.ofNullable(this.projectSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserSettingsSource() {
                return Optional.ofNullable(this.userSettingsSource);
            }

            @Override
            @Nonnull
            public Optional<UnaryOperator<String>> getInterpolationSource() {
                return Optional.ofNullable(this.interpolationSource);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultSettingsBuilderRequest)) return false;
                DefaultSettingsBuilderRequest that = (DefaultSettingsBuilderRequest)o;
                if (!Objects.equals(this.installationSettingsSource, that.installationSettingsSource)) return false;
                if (!Objects.equals(this.projectSettingsSource, that.projectSettingsSource)) return false;
                if (!Objects.equals(this.userSettingsSource, that.userSettingsSource)) return false;
                if (!Objects.equals(this.interpolationSource, that.interpolationSource)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.installationSettingsSource, this.projectSettingsSource, this.userSettingsSource, this.interpolationSource);
            }

            @Override
            public String toString() {
                return "SettingsBuilderRequest[installationSettingsSource=" + String.valueOf(this.installationSettingsSource) + ", projectSettingsSource=" + String.valueOf(this.projectSettingsSource) + ", userSettingsSource=" + String.valueOf(this.userSettingsSource) + ", interpolationSource=" + String.valueOf(this.interpolationSource) + "]";
            }
        }
    }
}

