/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.NoGoalSpecifiedException;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.GoalTask;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.lifecycle.internal.LifecycleTask;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.PhaseId;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.concurrent.BuildPlanExecutor;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="concurrent")
@Singleton
public class ConcurrentLifecycleStarter
implements LifecycleStarter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutionEventCatapult eventCatapult;
    private final DefaultLifecycles defaultLifeCycles;
    private final BuildPlanExecutor executor;
    private final LifecyclePluginResolver lifecyclePluginResolver;
    private final MojoDescriptorCreator mojoDescriptorCreator;

    @Inject
    public ConcurrentLifecycleStarter(ExecutionEventCatapult eventCatapult, DefaultLifecycles defaultLifeCycles, BuildPlanExecutor executor, LifecyclePluginResolver lifecyclePluginResolver, MojoDescriptorCreator mojoDescriptorCreator) {
        this.eventCatapult = eventCatapult;
        this.defaultLifeCycles = defaultLifeCycles;
        this.executor = executor;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
        this.mojoDescriptorCreator = mojoDescriptorCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MavenSession session) {
        this.eventCatapult.fire(ExecutionEvent.Type.SessionStarted, session, null);
        try {
            if (this.requiresProject(session) && this.projectIsNotPresent(session)) {
                throw new MissingProjectException("The goal you specified requires a project to execute but there is no POM in this directory (" + String.valueOf(session.getTopDirectory()) + "). Please verify you invoked Maven from the correct directory.");
            }
            List<TaskSegment> taskSegments = this.calculateTaskSegments(session);
            if (taskSegments.isEmpty()) {
                throw new NoGoalSpecifiedException("No goals have been specified for this build. You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + ".");
            }
            int degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
            if (degreeOfConcurrency > 1) {
                this.logger.info("");
                this.logger.info(String.format("Using the %s implementation with a thread count of %d", this.executor.getClass().getSimpleName(), degreeOfConcurrency));
            }
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            ReactorBuildStatus reactorBuildStatus = new ReactorBuildStatus(session.getProjectDependencyGraph());
            ReactorContext reactorContext = new ReactorContext(session.getResult(), oldContextClassLoader, reactorBuildStatus);
            this.executor.execute(session, reactorContext, taskSegments);
        }
        catch (Exception e) {
            session.getResult().addException(e);
        }
        finally {
            this.eventCatapult.fire(ExecutionEvent.Type.SessionEnded, session, null);
        }
    }

    public List<TaskSegment> calculateTaskSegments(MavenSession session) throws Exception {
        MavenProject rootProject = session.getTopLevelProject();
        List<String> tasks = Objects.requireNonNull(session.getGoals());
        if (tasks.isEmpty() && rootProject.getDefaultGoal() != null && !rootProject.getDefaultGoal().isEmpty()) {
            tasks = Stream.of(rootProject.getDefaultGoal().split("\\s+")).filter(g -> !g.isEmpty()).collect(Collectors.toList());
        }
        return this.calculateTaskSegments(session, tasks);
    }

    public List<TaskSegment> calculateTaskSegments(MavenSession session, List<String> tasks) throws Exception {
        ArrayList<TaskSegment> taskSegments = new ArrayList<TaskSegment>(tasks.size());
        TaskSegment currentSegment = null;
        for (String task : tasks) {
            if (this.isBeforeOrAfterPhase(task)) {
                String prevTask = task;
                task = PhaseId.of(task).phase();
                this.logger.warn("Illegal call to phase '{}'. The main phase '{}' will be used instead.", (Object)prevTask, (Object)task);
            }
            if (this.isGoalSpecification(task)) {
                boolean aggregating;
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session.getTopLevelProject(), session);
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(task, session, session.getTopLevelProject());
                boolean bl = aggregating = mojoDescriptor.isAggregator() || !mojoDescriptor.isProjectRequired();
                if (currentSegment == null || currentSegment.isAggregating() != aggregating) {
                    currentSegment = new TaskSegment(aggregating);
                    taskSegments.add(currentSegment);
                }
                currentSegment.getTasks().add(new GoalTask(task));
                continue;
            }
            if (currentSegment == null || currentSegment.isAggregating()) {
                currentSegment = new TaskSegment(false);
                taskSegments.add(currentSegment);
            }
            currentSegment.getTasks().add(new LifecycleTask(task));
        }
        return taskSegments;
    }

    private boolean projectIsNotPresent(MavenSession session) {
        return !session.getRequest().isProjectPresent();
    }

    private boolean requiresProject(MavenSession session) {
        List<String> goals = session.getGoals();
        if (goals != null) {
            for (String goal : goals) {
                if (this.isGoalSpecification(goal)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBeforeOrAfterPhase(String task) {
        return task.startsWith("before:") || task.startsWith("after:");
    }

    private boolean isGoalSpecification(String task) {
        return task.indexOf(58) >= 0;
    }
}

