/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;

@Named
@Singleton
public class LifecyclePluginResolver {
    private final PluginVersionResolver pluginVersionResolver;

    @Inject
    public LifecyclePluginResolver(PluginVersionResolver pluginVersionResolver) {
        this.pluginVersionResolver = pluginVersionResolver;
    }

    public void resolveMissingPluginVersions(MavenProject project, MavenSession session) throws PluginVersionResolutionException {
        HashMap<String, String> versions = new HashMap<String, String>(64);
        for (Plugin plugin : project.getBuildPlugins()) {
            if (plugin.getVersion() == null) {
                DefaultPluginVersionRequest request = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
                plugin.setVersion(this.pluginVersionResolver.resolve(request).getVersion());
            }
            versions.put(plugin.getKey(), plugin.getVersion());
        }
        PluginManagement pluginManagement = project.getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                if (plugin.getVersion() != null) continue;
                plugin.setVersion((String)versions.get(plugin.getKey()));
                if (plugin.getVersion() != null) continue;
                DefaultPluginVersionRequest request = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
                plugin.setVersion(this.pluginVersionResolver.resolve(request).getVersion());
            }
        }
    }
}

