/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.interactivity;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Named;
import org.apache.maven.logging.ProjectBuildLogAppender;
import org.codehaus.plexus.components.interactivity.AbstractInputHandler;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.Typed;
import org.mvndaemon.mvnd.common.Message;
import org.mvndaemon.mvnd.daemon.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Priority(value=20)
@Typed(value={Prompter.class, InputHandler.class, OutputHandler.class})
public class DaemonPrompter
extends AbstractInputHandler
implements Prompter,
InputHandler,
OutputHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonPrompter.class);

    public String prompt(String message) throws PrompterException {
        return this.prompt(message, null, null);
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        return this.prompt(message, null, defaultReply);
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        return this.doPrompt(message, possibleValues, defaultReply, false);
    }

    public String promptForPassword(String message) throws PrompterException {
        return this.doPrompt(message, null, null, true);
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.doDisplay(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
    }

    public String readLine() throws IOException {
        return this.doPrompt(null, false);
    }

    public String readPassword() throws IOException {
        return this.doPrompt(null, true);
    }

    public void write(String line) throws IOException {
        this.doDisplay(line);
    }

    public void writeLine(String line) throws IOException {
        this.doDisplay(line + "\n");
    }

    String doPrompt(String message, List<Object> possibleValues, String defaultReply, boolean password) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            try {
                line = this.doPrompt(formattedMessage, password);
                if (line == null && defaultReply == null) {
                    throw new IOException("EOF");
                }
            }
            catch (IOException e) {
                throw new PrompterException("Failed to prompt user", (Throwable)e);
            }
            if (line == null || line.isEmpty()) {
                line = defaultReply;
            }
            if (line == null || possibleValues == null || possibleValues.contains(line)) continue;
            try {
                this.doDisplay("Invalid selection.\n");
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", (Throwable)e);
            }
        } while (line == null || possibleValues != null && !possibleValues.contains(line));
        return line;
    }

    private String formatMessage(String message, List<Object> possibleValues, String defaultReply) {
        StringBuilder formatted = new StringBuilder(message.length() * 2);
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator<Object> it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = String.valueOf(it.next());
                formatted.append(possibleValue);
                if (!it.hasNext()) continue;
                formatted.append('/');
            }
            formatted.append(')');
        }
        if (defaultReply != null) {
            formatted.append(' ').append(defaultReply).append(": ");
        }
        return formatted.toString();
    }

    private void doDisplay(String message) throws IOException {
        try {
            Connection con = Objects.requireNonNull(Connection.getCurrent());
            String projectId = ProjectBuildLogAppender.getProjectId();
            Message.ProjectEvent msg = Message.display((String)projectId, (String)message);
            LOGGER.debug("Sending display request: {}", (Object)msg);
            con.dispatch((Message)msg);
        }
        catch (Exception e) {
            throw new IOException("Unable to display message", e);
        }
    }

    private String doPrompt(String message, boolean password) throws IOException {
        try {
            Connection con = Objects.requireNonNull(Connection.getCurrent());
            String projectId = ProjectBuildLogAppender.getProjectId();
            String uid = UUID.randomUUID().toString();
            Message.Prompt msg = new Message.Prompt(projectId, uid, message, password);
            LOGGER.debug("Requesting prompt: {}", (Object)msg);
            Message.PromptResponse res = con.request((Message)msg, Message.PromptResponse.class, r -> uid.equals(r.getUid()));
            LOGGER.debug("Received response: {}", (Object)res.getMessage());
            return res.getMessage();
        }
        catch (Exception e) {
            throw new IOException("Unable to prompt user", e);
        }
    }
}

