package org.apache.maven.its.wagon;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;

import org.apache.maven.wagon.*;
import org.apache.maven.wagon.authentication.*;
import org.apache.maven.wagon.authorization.*;

/**
 * Dummy Wagon Provider for testing.
 * 
 * @plexus.component role="org.apache.maven.wagon.Wagon" role-hint="coreit" instantiation-strategy="per-lookup"
 */
public class CoreItWagon
    extends AbstractWagon
{

    protected void closeConnection()
        throws ConnectionException
    {
    }

    protected void openConnectionInternal()
        throws ConnectionException, AuthenticationException
    {
    }

    public void openConnection()
        throws ConnectionException, AuthenticationException
    {
    }

    public void put( File source, String resourceName )
        throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException
    {
    }

    public void get( String resourceName, File destination )
        throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException
    {
    }

    public boolean getIfNewer( String resourceName, File destination, long timestamp )
        throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException
    {
        return false;
    }

}
