/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class PomDiscovery {
    public static Map<Path, Document> discoverPoms(Path startDirectory) throws IOException, JDOMException {
        HashMap<Path, Document> pomMap = new HashMap<Path, Document>();
        Path rootPomPath = startDirectory.resolve("pom.xml");
        if (!Files.exists(rootPomPath, new LinkOption[0])) {
            throw new IOException("No pom.xml found in directory: " + String.valueOf(startDirectory));
        }
        Document rootPom = PomDiscovery.loadPom(rootPomPath);
        pomMap.put(rootPomPath, rootPom);
        PomDiscovery.discoverModules(startDirectory, rootPom, pomMap);
        return pomMap;
    }

    private static void discoverModules(Path currentDirectory, Document pomDocument, Map<Path, Document> pomMap) throws IOException, JDOMException {
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        String modelVersion = PomDiscovery.detectModelVersion(pomDocument);
        boolean is410OrLater = "4.1.0".equals(modelVersion) || PomDiscovery.isNewerThan410(modelVersion);
        boolean foundModulesOrSubprojects = false;
        foundModulesOrSubprojects |= PomDiscovery.discoverFromModules(currentDirectory, root, namespace, pomMap);
        if (is410OrLater) {
            foundModulesOrSubprojects |= PomDiscovery.discoverFromSubprojects(currentDirectory, root, namespace, pomMap);
        }
        if (is410OrLater && !(foundModulesOrSubprojects |= PomDiscovery.discoverFromProfiles(currentDirectory, root, namespace, pomMap, is410OrLater))) {
            PomDiscovery.discoverFromDirectories(currentDirectory, pomMap);
        }
    }

    private static String detectModelVersion(Document pomDocument) {
        String namespaceUri;
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        String explicitVersion = null;
        String namespaceVersion = null;
        Element modelVersionElement = root.getChild("modelVersion", namespace);
        if (modelVersionElement != null) {
            explicitVersion = modelVersionElement.getTextTrim();
        }
        if (namespace != null && namespace.getURI() != null && (namespaceUri = namespace.getURI()).contains("4.1.0")) {
            namespaceVersion = "4.1.0";
        }
        if (explicitVersion != null && !explicitVersion.isEmpty()) {
            if (namespaceVersion != null && !explicitVersion.equals(namespaceVersion)) {
                System.err.println("WARNING: Model version mismatch in POM - explicit: " + explicitVersion + ", namespace suggests: " + namespaceVersion + ". Using explicit version.");
            }
            return explicitVersion;
        }
        if (namespaceVersion != null) {
            return namespaceVersion;
        }
        System.err.println("WARNING: No model version found in POM, falling back to 4.0.0");
        return "4.0.0";
    }

    private static boolean isNewerThan410(String modelVersion) {
        return modelVersion.compareTo("4.1.0") > 0;
    }

    private static boolean discoverFromModules(Path currentDirectory, Element root, Namespace namespace, Map<Path, Document> pomMap) throws IOException, JDOMException {
        Element modulesElement = root.getChild("modules", namespace);
        if (modulesElement != null) {
            List moduleElements = modulesElement.getChildren("module", namespace);
            for (Element moduleElement : moduleElements) {
                String modulePath = moduleElement.getTextTrim();
                if (modulePath.isEmpty()) continue;
                PomDiscovery.discoverModule(currentDirectory, modulePath, pomMap);
            }
            return !moduleElements.isEmpty();
        }
        return false;
    }

    private static boolean discoverFromSubprojects(Path currentDirectory, Element root, Namespace namespace, Map<Path, Document> pomMap) throws IOException, JDOMException {
        Element subprojectsElement = root.getChild("subprojects", namespace);
        if (subprojectsElement != null) {
            List subprojectElements = subprojectsElement.getChildren("subproject", namespace);
            for (Element subprojectElement : subprojectElements) {
                String subprojectPath = subprojectElement.getTextTrim();
                if (subprojectPath.isEmpty()) continue;
                PomDiscovery.discoverModule(currentDirectory, subprojectPath, pomMap);
            }
            return !subprojectElements.isEmpty();
        }
        return false;
    }

    private static boolean discoverFromProfiles(Path currentDirectory, Element root, Namespace namespace, Map<Path, Document> pomMap, boolean is410OrLater) throws IOException, JDOMException {
        boolean foundAny = false;
        Element profilesElement = root.getChild("profiles", namespace);
        if (profilesElement != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                foundAny |= PomDiscovery.discoverFromModules(currentDirectory, profileElement, namespace, pomMap);
                if (!is410OrLater) continue;
                foundAny |= PomDiscovery.discoverFromSubprojects(currentDirectory, profileElement, namespace, pomMap);
            }
        }
        return foundAny;
    }

    private static void discoverFromDirectories(Path currentDirectory, Map<Path, Document> pomMap) throws IOException, JDOMException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(currentDirectory, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path childDir : stream) {
                Path childPomPath = childDir.resolve("pom.xml");
                if (!Files.exists(childPomPath, new LinkOption[0]) || pomMap.containsKey(childPomPath)) continue;
                Document childPom = PomDiscovery.loadPom(childPomPath);
                pomMap.put(childPomPath, childPom);
                PomDiscovery.discoverModules(childDir, childPom, pomMap);
            }
        }
    }

    private static void discoverModule(Path currentDirectory, String modulePath, Map<Path, Document> pomMap) throws IOException, JDOMException {
        Path moduleDirectory;
        Path modulePomPath;
        Path resolvedPath = currentDirectory.resolve(modulePath);
        if (modulePath.endsWith("pom.xml") || Files.exists(resolvedPath, new LinkOption[0]) && Files.isRegularFile(resolvedPath, new LinkOption[0])) {
            modulePomPath = resolvedPath;
            moduleDirectory = resolvedPath.getParent();
        } else {
            moduleDirectory = resolvedPath;
            modulePomPath = moduleDirectory.resolve("pom.xml");
        }
        if (Files.exists(modulePomPath, new LinkOption[0]) && !pomMap.containsKey(modulePomPath)) {
            Document modulePom = PomDiscovery.loadPom(modulePomPath);
            pomMap.put(modulePomPath, modulePom);
            PomDiscovery.discoverModules(moduleDirectory, modulePom, pomMap);
        }
    }

    private static Document loadPom(Path pomPath) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        return builder.build(pomPath.toFile());
    }
}

