/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.internal.extension.io;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.cli.extensions.CoreExtensions;
import org.apache.maven.api.cli.extensions.InputLocation;
import org.apache.maven.api.cli.extensions.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.stax2.util.StreamWriterDelegate;

@Generated
public class CoreExtensionsStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/EXTENSIONS/1.2.0";
    private static final String SCHEMA_LOCATION = "https://maven.apache.org/xsd/core-extensions-1.2.0.xsd";
    private String namespace = "http://maven.apache.org/EXTENSIONS/1.2.0";
    private String schemaLocation = "https://maven.apache.org/xsd/core-extensions-1.2.0.xsd";
    private String fileComment = null;
    private boolean addLocationInformation = true;
    protected Function<InputLocation, String> stringFormatter;

    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    }

    public void setStringFormatter(Function<InputLocation, String> stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    public void write(Writer writer, CoreExtensions coreExtensions) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(coreExtensions.getModelEncoding(), null);
        this.writeCoreExtensions("extensions", coreExtensions, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, CoreExtensions coreExtensions) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, coreExtensions.getModelEncoding()));
        serializer.writeStartDocument(coreExtensions.getModelEncoding(), null);
        this.writeCoreExtensions("extensions", coreExtensions, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    private void writeCoreExtensions(String tagName, CoreExtensions coreExtensions, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (coreExtensions != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, this.namespace);
            serializer.writeNamespace("", this.namespace);
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.namespace + " " + this.schemaLocation);
            this.writeList("extensions", true, coreExtensions.getExtensions(), serializer, (InputLocationTracker)coreExtensions, t -> this.writeCoreExtension("extension", (CoreExtension)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeCoreExtension(String tagName, CoreExtension coreExtension, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (coreExtension != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, coreExtension.getGroupId(), serializer, (InputLocationTracker)coreExtension);
            this.writeTag("artifactId", null, coreExtension.getArtifactId(), serializer, (InputLocationTracker)coreExtension);
            this.writeTag("version", null, coreExtension.getVersion(), serializer, (InputLocationTracker)coreExtension);
            this.writeTag("classLoadingStrategy", "self-first", coreExtension.getClassLoadingStrategy(), serializer, (InputLocationTracker)coreExtension);
            this.writeDom(coreExtension.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, locationTracker, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(this.namespace, tagName);
            }
            int index = 0;
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (T t : list) {
                writer.write(t);
                this.writeLocationTracking((InputLocationTracker)location, index++, serializer);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(this.namespace, tagName);
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer, null);
                this.writeLocationTracking((InputLocationTracker)location, key, serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            Object object;
            serializer.writeStartElement(this.namespace, dom.name());
            for (Map.Entry attr : dom.attributes().entrySet()) {
                if (((String)attr.getKey()).startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace", ((String)attr.getKey()).substring(4), (String)attr.getValue());
                    continue;
                }
                serializer.writeAttribute((String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.children()) {
                this.writeDom(child, serializer);
            }
            String value = dom.value();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
            if (this.addLocationInformation && (object = dom.inputLocation()) instanceof InputLocation) {
                InputLocation inputLocation = (InputLocation)object;
                if (dom.children().isEmpty()) {
                    serializer.writeComment(this.toString(inputLocation));
                }
            }
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
            this.writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    protected void writeLocationTracking(InputLocationTracker locationTracker, Object key, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (this.addLocationInformation) {
            InputLocation location;
            InputLocation inputLocation = location = locationTracker == null ? null : locationTracker.getLocation(key);
            if (location != null) {
                serializer.writeComment(this.toString(location));
            }
        }
    }

    protected String toString(InputLocation location) {
        if (this.stringFormatter != null) {
            return this.stringFormatter.apply(location);
        }
        if (location.getSource() != null) {
            return " " + location.getSource().toString() + ":" + location.getLineNumber() + " ";
        }
        return " " + location.getLineNumber() + " ";
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

