/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.transformer.ClassicConflictResolver;
import org.eclipse.aether.util.graph.transformer.PathConflictResolver;

public class ConflictResolver
implements DependencyGraphTransformer {
    public static final String CONFIG_PROP_VERBOSE = "aether.conflictResolver.verbose";
    public static final String CONFIG_PROP_CONFLICT_RESOLVER_IMPL = "aether.conflictResolver.impl";
    public static final String CLASSIC_CONFLICT_RESOLVER = "classic";
    public static final String PATH_CONFLICT_RESOLVER = "path";
    public static final String DEFAULT_CONFLICT_RESOLVER_IMPL = "path";
    public static final String NODE_DATA_WINNER = "conflict.winner";
    public static final String NODE_DATA_ORIGINAL_SCOPE = "conflict.originalScope";
    public static final String NODE_DATA_ORIGINAL_OPTIONALITY = "conflict.originalOptionality";
    private final VersionSelector versionSelector;
    private final ScopeSelector scopeSelector;
    private final ScopeDeriver scopeDeriver;
    private final OptionalitySelector optionalitySelector;

    public static Verbosity getVerbosity(RepositorySystemSession session) {
        Object verbosityValue = session.getConfigProperties().get(CONFIG_PROP_VERBOSE);
        if (verbosityValue instanceof Boolean) {
            return (Boolean)verbosityValue != false ? Verbosity.STANDARD : Verbosity.NONE;
        }
        if (verbosityValue instanceof String) {
            return Boolean.parseBoolean(verbosityValue.toString()) ? Verbosity.STANDARD : Verbosity.NONE;
        }
        if (verbosityValue instanceof Verbosity) {
            return (Verbosity)((Object)verbosityValue);
        }
        if (verbosityValue != null) {
            throw new IllegalArgumentException("Unsupported Verbosity configuration: " + verbosityValue);
        }
        return Verbosity.NONE;
    }

    protected ConflictResolver() {
        this.versionSelector = null;
        this.scopeSelector = null;
        this.scopeDeriver = null;
        this.optionalitySelector = null;
    }

    public ConflictResolver(VersionSelector versionSelector, ScopeSelector scopeSelector, OptionalitySelector optionalitySelector, ScopeDeriver scopeDeriver) {
        this.versionSelector = Objects.requireNonNull(versionSelector, "version selector cannot be null");
        this.scopeSelector = Objects.requireNonNull(scopeSelector, "scope selector cannot be null");
        this.optionalitySelector = Objects.requireNonNull(optionalitySelector, "optionality selector cannot be null");
        this.scopeDeriver = Objects.requireNonNull(scopeDeriver, "scope deriver cannot be null");
    }

    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        ConflictResolver delegate;
        String cf = ConfigUtils.getString(context.getSession(), "path", CONFIG_PROP_CONFLICT_RESOLVER_IMPL);
        if ("path".equals(cf)) {
            delegate = new PathConflictResolver(this.versionSelector, this.scopeSelector, this.optionalitySelector, this.scopeDeriver);
        } else if (CLASSIC_CONFLICT_RESOLVER.equals(cf)) {
            delegate = new ClassicConflictResolver(this.versionSelector, this.scopeSelector, this.optionalitySelector, this.scopeDeriver);
        } else {
            throw new IllegalArgumentException("Unknown conflict resolver: " + cf + "; known are " + Arrays.asList("path", CLASSIC_CONFLICT_RESOLVER));
        }
        return ((ConflictResolver)delegate).transformGraph(node, context);
    }

    public static enum Verbosity {
        NONE,
        STANDARD,
        FULL;

    }

    public static abstract class VersionSelector {
        public VersionSelector getInstance(DependencyNode root, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void selectVersion(ConflictContext var1) throws RepositoryException;
    }

    public static abstract class ScopeSelector {
        public ScopeSelector getInstance(DependencyNode root, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void selectScope(ConflictContext var1) throws RepositoryException;
    }

    public static abstract class ScopeDeriver {
        public ScopeDeriver getInstance(DependencyNode root, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void deriveScope(ScopeContext var1) throws RepositoryException;
    }

    public static abstract class OptionalitySelector {
        public OptionalitySelector getInstance(DependencyNode root, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void selectOptionality(ConflictContext var1) throws RepositoryException;
    }

    public static abstract class ConflictContext {
        public abstract DependencyNode getRoot();

        public abstract boolean isIncluded(DependencyNode var1);

        public abstract Collection<ConflictItem> getItems();

        public abstract ConflictItem getWinner();

        public abstract void setWinner(ConflictItem var1);

        public abstract String getScope();

        public abstract void setScope(String var1);

        public abstract Boolean getOptional();

        public abstract void setOptional(Boolean var1);
    }

    public static abstract class ConflictItem {
        public static final int OPTIONAL_FALSE = 1;
        public static final int OPTIONAL_TRUE = 2;

        public abstract boolean isSibling(ConflictItem var1);

        public abstract DependencyNode getNode();

        public abstract Dependency getDependency();

        public abstract int getDepth();

        public abstract Collection<String> getScopes();

        public abstract int getOptionalities();
    }

    public static abstract class ScopeContext {
        public abstract String getParentScope();

        public abstract String getChildScope();

        public abstract String getDerivedScope();

        public abstract void setDerivedScope(String var1);
    }
}

