/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.ItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.SecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeMutability;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ItemTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeMutabilityImpl;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.types.TypeUtil;
import org.apache.chemistry.opencmis.server.support.TypeManager;

public final class TypeValidator {
    private static final Object CMIS_USER = "cmis:user";

    private TypeValidator() {
    }

    public static void checkType(TypeManager tm, TypeDefinition td) {
        if (null == td) {
            throw new CmisInvalidArgumentException("Cannot add type, because the type defintion is null.");
        }
        if (null == tm.getTypeById(td.getParentTypeId())) {
            throw new CmisInvalidArgumentException("Cannot add type, because parent with id " + td.getParentTypeId() + " does not exist.");
        }
        if (null != tm.getTypeById(td.getId())) {
            throw new CmisInvalidArgumentException("Cannot add type, because type with id " + td.getId() + " already exists.");
        }
        TypeValidator.checkTypeId(tm, td.getId());
        TypeValidator.checkTypeQueryName(tm, td.getQueryName());
        TypeValidator.checkTypeLocalName(tm, td.getLocalName());
        TypeValidator.checkBaseAndParentType(td);
        if (null != td.getPropertyDefinitions()) {
            TypeValidator.checkProperties(tm, td.getPropertyDefinitions().values());
        }
    }

    public static AbstractTypeDefinition completeType(TypeDefinition type) {
        if (type instanceof DocumentTypeDefinition) {
            return TypeValidator.completeTypeDoc((DocumentTypeDefinition)type);
        }
        if (type instanceof FolderTypeDefinition) {
            return TypeValidator.completeTypeFolder((FolderTypeDefinition)type);
        }
        if (type instanceof PolicyTypeDefinition) {
            return TypeValidator.completeTypePolicy((PolicyTypeDefinition)type);
        }
        if (type instanceof ItemTypeDefinition) {
            return TypeValidator.completeTypeItem((ItemTypeDefinition)type);
        }
        if (type instanceof RelationshipTypeDefinition) {
            return TypeValidator.completeTypeRelationship((RelationshipTypeDefinition)type);
        }
        if (type instanceof SecondaryTypeDefinition) {
            return TypeValidator.completeTypeSecondary((SecondaryTypeDefinition)type);
        }
        return null;
    }

    public static void adjustTypeNamesAndId(AbstractTypeDefinition typeDef) {
        if (null == typeDef.getId()) {
            typeDef.setId(UUID.randomUUID().toString());
        } else if (!NameValidator.isValidId(typeDef.getId())) {
            String newId = TypeValidator.replaceInvalidCharacters(typeDef.getId());
            typeDef.setId(newId);
        }
        if (!NameValidator.isValidQueryName(typeDef.getQueryName())) {
            typeDef.setQueryName(typeDef.getId());
        }
        if (!NameValidator.isValidLocalName(typeDef.getLocalName())) {
            typeDef.setLocalName(typeDef.getId());
        }
    }

    private static void completeAbstractTypeDefinition(AbstractTypeDefinition td) {
        if (td.isControllableAcl() == null) {
            td.setIsControllableAcl(Boolean.valueOf(true));
        }
        if (td.isControllablePolicy() == null) {
            td.setIsControllablePolicy(Boolean.valueOf(false));
        }
        if (td.isCreatable() == null) {
            td.setIsCreatable(Boolean.valueOf(true));
        }
        if (td.isFileable() == null) {
            td.setIsFileable(Boolean.valueOf(true));
        }
        td.setIsFulltextIndexed(Boolean.valueOf(false));
        td.setIsIncludedInSupertypeQuery(Boolean.valueOf(false));
        if (td.isQueryable() == null) {
            td.setIsQueryable(Boolean.valueOf(true));
        }
        td.setParentTypeId(td.getParentTypeId());
        TypeMutabilityImpl tm = new TypeMutabilityImpl();
        tm.setCanCreate(Boolean.valueOf(true));
        tm.setCanDelete(Boolean.valueOf(true));
        tm.setCanUpdate(Boolean.valueOf(true));
        td.setTypeMutability((TypeMutability)tm);
        td.setExtensions(td.getExtensions());
        LinkedHashMap<String, PropertyDefinition> propDefsNew = new LinkedHashMap<String, PropertyDefinition>();
        if (null != td.getPropertyDefinitions()) {
            Map propDefs = td.getPropertyDefinitions();
            for (PropertyDefinition pd : propDefs.values()) {
                AbstractPropertyDefinition<?> pdNew = TypeValidator.completePropertyDef(pd);
                TypeValidator.adjustPropertyNamesAndId(pdNew);
                propDefsNew.put(pdNew.getId(), pd);
            }
        }
        td.setPropertyDefinitions(propDefsNew);
    }

    private static void checkProperties(TypeManager tm, Collection<PropertyDefinition<?>> pds) {
        Collection tdl = tm.getTypeDefinitionList();
        for (PropertyDefinition<?> pd2 : pds) {
            if (null == pd2.getId()) {
                throw new CmisInvalidArgumentException("property id cannot be null.");
            }
            if (!NameValidator.isValidId(pd2.getId())) {
                throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
            }
            if (null == pd2.getQueryName()) {
                throw new CmisInvalidArgumentException("property query name cannot be null.");
            }
            if (!NameValidator.isValidQueryName(pd2.getQueryName())) {
                throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
            }
            if (null == pd2.getLocalName()) {
                throw new CmisInvalidArgumentException("property local name cannot be null.");
            }
            if (!NameValidator.isValidLocalName(pd2.getLocalName())) {
                throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
            }
            for (TypeDefinitionContainer tdc : tdl) {
                TypeDefinition td = tdc.getTypeDefinition();
                if (null == td.getPropertyDefinitions()) continue;
                for (PropertyDefinition pd1 : td.getPropertyDefinitions().values()) {
                    if (pd1.getId().equals(pd2.getId())) {
                        throw new CmisConstraintException("Property id " + pd2.getId() + " already in use in type " + td.getId());
                    }
                    if (pd1.getQueryName().equals(pd2.getQueryName())) {
                        throw new CmisConstraintException("Property query name " + pd2.getQueryName() + " already in use in type " + td.getQueryName());
                    }
                    if (!pd1.getLocalName().equals(pd2.getLocalName())) continue;
                    throw new CmisConstraintException("Property local name " + pd2.getLocalName() + " already in use in type " + td.getId());
                }
            }
        }
    }

    private static void adjustPropertyNamesAndId(AbstractPropertyDefinition<?> propDef) {
        if (null == propDef.getId()) {
            propDef.setId(UUID.randomUUID().toString());
        } else if (!NameValidator.isValidId(propDef.getId())) {
            String newId = TypeValidator.replaceInvalidCharacters(propDef.getId());
            propDef.setId(newId);
        }
        if (!NameValidator.isValidQueryName(propDef.getQueryName())) {
            propDef.setQueryName(propDef.getId());
        }
        if (!NameValidator.isValidLocalName(propDef.getLocalName())) {
            propDef.setLocalName(propDef.getId());
        }
    }

    private static String replaceInvalidCharacters(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            if (NameValidator.isValidId(id.substring(i, i + 1))) {
                sb.append(id.charAt(i));
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static DocumentTypeDefinitionImpl completeTypeDoc(DocumentTypeDefinition type) {
        DocumentTypeDefinitionImpl td = TypeUtil.cloneTypeDoc(type);
        TypeValidator.completeAbstractTypeDefinition((AbstractTypeDefinition)td);
        td.setIsVersionable(type.isVersionable());
        td.setContentStreamAllowed(type.getContentStreamAllowed());
        if (td.isVersionable() == null) {
            td.setIsVersionable(Boolean.valueOf(false));
        }
        if (td.getContentStreamAllowed() == null) {
            td.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        }
        return td;
    }

    private static FolderTypeDefinitionImpl completeTypeFolder(FolderTypeDefinition type) {
        FolderTypeDefinitionImpl td = TypeUtil.cloneTypeFolder(type);
        TypeValidator.completeAbstractTypeDefinition((AbstractTypeDefinition)td);
        return td;
    }

    private static RelationshipTypeDefinitionImpl completeTypeRelationship(RelationshipTypeDefinition type) {
        RelationshipTypeDefinitionImpl td = TypeUtil.cloneTypeRelationship(type);
        TypeValidator.completeAbstractTypeDefinition((AbstractTypeDefinition)td);
        td.setAllowedSourceTypes(type.getAllowedSourceTypeIds());
        td.setAllowedTargetTypes(type.getAllowedTargetTypeIds());
        return td;
    }

    private static ItemTypeDefinitionImpl completeTypeItem(ItemTypeDefinition type) {
        ItemTypeDefinitionImpl td = TypeUtil.cloneTypeItem(type);
        td.initialize((TypeDefinition)type);
        TypeValidator.completeAbstractTypeDefinition((AbstractTypeDefinition)td);
        return td;
    }

    private static SecondaryTypeDefinitionImpl completeTypeSecondary(SecondaryTypeDefinition type) {
        SecondaryTypeDefinitionImpl td = TypeUtil.cloneTypeSecondary(type);
        TypeValidator.completeAbstractTypeDefinition((AbstractTypeDefinition)td);
        return td;
    }

    private static PolicyTypeDefinitionImpl completeTypePolicy(PolicyTypeDefinition type) {
        PolicyTypeDefinitionImpl td = TypeUtil.cloneTypePolicy(type);
        TypeValidator.completeAbstractTypeDefinition((AbstractTypeDefinition)td);
        return null;
    }

    private static AbstractPropertyDefinition<?> completePropertyDef(PropertyDefinition<?> pdSrc) {
        AbstractPropertyDefinition<?> newPropDef = TypeUtil.clonePropertyDefinition(pdSrc);
        if (null == newPropDef.getPropertyType()) {
            throw new CmisInvalidArgumentException("Property " + pdSrc.getId() + "has no property type.");
        }
        if (null == newPropDef.getId()) {
            newPropDef.setId(UUID.randomUUID().toString());
        }
        if (null == newPropDef.getQueryName()) {
            newPropDef.setQueryName(pdSrc.getId());
        }
        if (null == newPropDef.getLocalName()) {
            newPropDef.setLocalName(pdSrc.getId());
        }
        if (null == newPropDef.getCardinality()) {
            newPropDef.setCardinality(Cardinality.SINGLE);
        }
        if (null == newPropDef.isOrderable()) {
            newPropDef.setIsOrderable(Boolean.valueOf(true));
        }
        if (null == newPropDef.isQueryable()) {
            newPropDef.setIsQueryable(Boolean.valueOf(true));
        }
        if (null == newPropDef.isRequired()) {
            newPropDef.setIsRequired(Boolean.valueOf(false));
        }
        if (null == newPropDef.getUpdatability()) {
            newPropDef.setUpdatability(Updatability.READWRITE);
        }
        return newPropDef;
    }

    public static Acl expandAclMakros(String user, Acl acl) {
        boolean mustCopy = false;
        if (user == null || acl == null || acl.getAces() == null) {
            return acl;
        }
        for (Ace ace : acl.getAces()) {
            String principal = ace.getPrincipalId();
            if (principal == null || !principal.equals(CMIS_USER)) continue;
            mustCopy = true;
        }
        if (mustCopy) {
            AccessControlListImpl result = new AccessControlListImpl();
            ArrayList<Object> list = new ArrayList<Object>(acl.getAces().size());
            for (Ace ace : acl.getAces()) {
                String principal = ace.getPrincipalId();
                if (principal != null && principal.equals(CMIS_USER)) {
                    AccessControlEntryImpl ace2 = new AccessControlEntryImpl();
                    ace2.setPermissions(ace.getPermissions());
                    ace2.setExtensions(ace.getExtensions());
                    ace2.setPrincipal((Principal)new AccessControlPrincipalDataImpl(user));
                    list.add(ace2);
                    continue;
                }
                list.add(ace);
            }
            result.setAces(list);
            return result;
        }
        return acl;
    }

    private static void checkTypeId(TypeManager tm, String typeId) {
        if (null == typeId) {
            throw new CmisInvalidArgumentException("Type id cannot be null.");
        }
        if (!NameValidator.isValidId(typeId)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_'");
        }
        if (null != tm.getTypeById(typeId)) {
            throw new CmisInvalidArgumentException("You cannot add type with id " + typeId + " because it already exists.");
        }
    }

    private static void checkTypeQueryName(TypeManager tm, String queryName) {
        if (null == queryName) {
            throw new CmisInvalidArgumentException("Query name cannot be null.");
        }
        if (!NameValidator.isValidQueryName(queryName)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
        }
        if (null != tm.getTypeByQueryName(queryName)) {
            throw new CmisInvalidArgumentException("You cannot add type with query name " + queryName + " because it already exists.");
        }
    }

    private static void checkTypeLocalName(TypeManager tm, String localName) {
        if (null == localName) {
            throw new CmisInvalidArgumentException("Local name cannot be null.");
        }
        if (!NameValidator.isValidLocalName(localName)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
        }
        for (TypeDefinitionContainer tdc : tm.getTypeDefinitionList()) {
            if (!tdc.getTypeDefinition().getLocalName().equals(localName)) continue;
            throw new CmisConstraintException("You cannot add type with local name " + localName + " because it already exists.");
        }
    }

    private static void checkBaseAndParentType(TypeDefinition td) {
        if (null == td.getBaseTypeId()) {
            throw new CmisInvalidArgumentException("You cannot create a type without a base type id: " + td.getId());
        }
        if (null == td.getParentTypeId()) {
            throw new CmisInvalidArgumentException("You cannot create a type without a parent type id: " + td.getId());
        }
    }
}

