/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.manifoldcf.authorities.interfaces.AuthorityGroupManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroupManager;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.FilterCriteria;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;
import org.apache.manifoldcf.crawler.repository.RepositoryConnection;
import org.apache.manifoldcf.crawler.repository.RepositoryHistoryManager;
import org.apache.manifoldcf.crawler.repository.ThrottleSpecManager;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class RepositoryConnectionManager
extends BaseTable
implements IRepositoryConnectionManager {
    public static final String _rcsid = "@(#)$Id: RepositoryConnectionManager.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "connectionname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected static final String groupNameField = "groupname";
    protected static final String authorityNameField = "authorityname";
    protected static Random random = new Random();
    protected final RepositoryHistoryManager historyManager;
    protected final ThrottleSpecManager throttleSpecManager;
    protected final ICacheManager cacheManager;
    protected final IThreadContext threadContext;
    protected final ILockManager lockManager;
    protected final String repositoriesLock = "REPOSITORIES_LOCK";
    protected static final int FETCH_MAX = 200;

    public RepositoryConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "repoconnections");
        this.historyManager = new RepositoryHistoryManager(threadContext, database);
        this.throttleSpecManager = new ThrottleSpecManager(database);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block5: {
            IAuthorityGroupManager authMgr = AuthorityGroupManagerFactory.make(this.threadContext);
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(groupNameField, new ColumnDescription("VARCHAR(32)", false, true, authMgr.getTableName(), authMgr.getGroupNameColumn(), false));
                map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
            }
            this.historyManager.install(this.getTableName(), nameField);
            this.throttleSpecManager.install(this.getTableName(), nameField);
            IndexDescription authorityIndex = new IndexDescription(false, new String[]{groupNameField});
            IndexDescription classIndex = new IndexDescription(false, new String[]{classNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (authorityIndex != null && id.equals((Object)authorityIndex)) {
                    authorityIndex = null;
                    continue;
                }
                if (classIndex != null && id.equals((Object)classIndex)) {
                    classIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (authorityIndex != null) {
                this.performAddIndex(null, authorityIndex);
            }
            if (classIndex == null) break block5;
            this.performAddIndex(null, classIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            this.throttleSpecManager.deinstall();
            this.historyManager.deinstall();
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        IRepositoryConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IRepositoryConnection conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getACLAuthority());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
            String[] throttles = conn.getThrottles();
            ManifoldCF.writeDword((OutputStream)os, (int)throttles.length);
            int j = 0;
            while (j < throttles.length) {
                String throttleName = throttles[j++];
                ManifoldCF.writeString((OutputStream)os, (String)throttleName);
                ManifoldCF.writeString((OutputStream)os, (String)conn.getThrottleDescription(throttleName));
                ManifoldCF.writefloat((OutputStream)os, (float)conn.getThrottleValue(throttleName));
            }
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 1) {
            throw new IOException("Unknown repository connection configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IRepositoryConnection conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setACLAuthority(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            int throttleCount = ManifoldCF.readDword((InputStream)is);
            for (int j = 0; j < throttleCount; ++j) {
                String throttleName = ManifoldCF.readString((InputStream)is);
                conn.addThrottleValue(throttleName, ManifoldCF.readString((InputStream)is), ManifoldCF.readfloat((InputStream)is));
            }
            this.save(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryConnection[] getAllConnections() throws ManifoldCFException {
        this.lockManager.enterReadLock("REPOSITORIES_LOCK");
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(RepositoryConnectionManager.getRepositoryConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT connectionname,lower(connectionname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IRepositoryConnection[] iRepositoryConnectionArray = this.loadMultiple(names);
            return iRepositoryConnectionArray;
        }
        finally {
            this.lockManager.leaveReadLock("REPOSITORIES_LOCK");
        }
    }

    @Override
    public IRepositoryConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    @Override
    public IRepositoryConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        IRepositoryConnection[] rval = new IRepositoryConnection[names.length];
        if (names.length == 0) {
            return rval;
        }
        int inputIndex = 0;
        int outputIndex = 0;
        while (names.length - inputIndex > 200) {
            outputIndex = this.loadMultipleInternal(rval, outputIndex, names, inputIndex, 200);
            inputIndex += 200;
        }
        this.loadMultipleInternal(rval, outputIndex, names, inputIndex, names.length - inputIndex);
        return rval;
    }

    protected int loadMultipleInternal(IRepositoryConnection[] rval, int outputIndex, String[] fetchNames, int inputIndex, int length) throws ManifoldCFException {
        RepositoryConnection[] results;
        RepositoryConnectionDescription[] objectDescriptions = new RepositoryConnectionDescription[length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < length; ++i) {
            ssb.clear();
            String name = fetchNames[inputIndex + i];
            ssb.add(RepositoryConnectionManager.getRepositoryConnectionKey(name));
            objectDescriptions[i] = new RepositoryConnectionDescription(name, new StringSet(ssb));
        }
        RepositoryConnectionExecutor exec = new RepositoryConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        for (RepositoryConnection result : results = exec.getResults()) {
            rval[outputIndex++] = result;
        }
        return outputIndex;
    }

    @Override
    public IRepositoryConnection create() throws ManifoldCFException {
        RepositoryConnection rval = new RepositoryConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(IRepositoryConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(this.threadContext);
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(RepositoryConnectionManager.getRepositoryConnectionsKey());
        ssb.add(RepositoryConnectionManager.getRepositoryConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        this.lockManager.enterNonExWriteLock("REPOSITORIES_LOCK");
        try {
            ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
            try {
                this.beginTransaction();
                try {
                    if (jobManager.checkIfReference(name)) {
                        throw new ManifoldCFException("Can't delete repository connection '" + name + "': existing jobs refer to it");
                    }
                    ManifoldCF.noteConfigurationChange();
                    this.throttleSpecManager.deleteRows(name);
                    this.historyManager.deleteOwner(name);
                    ArrayList params = new ArrayList();
                    String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
                    this.performDelete("WHERE " + query, params, null);
                    this.cacheManager.invalidateKeys(ch);
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.cacheManager.leaveCache(ch);
            }
        }
        finally {
            this.lockManager.leaveNonExWriteLock("REPOSITORIES_LOCK");
        }
    }

    @Override
    public boolean isGroupReferenced(String groupName) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(RepositoryConnectionManager.getRepositoryConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(groupNameField, (Object)groupName)});
        IResultSet set = this.performQuery("SELECT connectionname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        return set.getRowCount() > 0;
    }

    @Override
    public String[] findConnectionsForConnector(String className) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(RepositoryConnectionManager.getRepositoryConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(classNameField, (Object)className)});
        IResultSet set = this.performQuery("SELECT connectionname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        Object[] rval = new String[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(nameField);
        }
        Arrays.sort(rval);
        return rval;
    }

    @Override
    public boolean checkConnectorExists(String name) throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(RepositoryConnectionManager.getRepositoryConnectionKey(name));
            StringSet localCacheKeys = new StringSet(ssb);
            ArrayList params = new ArrayList();
            String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
            IResultSet set = this.performQuery("SELECT classname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("No such connection: '" + name + "'");
            }
            IResultRow row = set.getRow(0);
            String className = (String)row.getValue(classNameField);
            IConnectorManager cm = ConnectorManagerFactory.make(this.threadContext);
            boolean bl = cm.isInstalled(className);
            return bl;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public String getConnectionNameColumn() {
        return nameField;
    }

    @Override
    public void cleanUpHistoryData(String connectionName) throws ManifoldCFException {
        this.historyManager.deleteOwner(connectionName);
    }

    @Override
    public void cleanUpHistoryData(long timeCutoff) throws ManifoldCFException {
        this.historyManager.deleteOldRows(timeCutoff);
    }

    @Override
    public void recordHistory(String connectionName, Long startTime, String activityType, Long dataSize, String entityIdentifier, String resultCode, String resultDescription, String[] childIdentifiers) throws ManifoldCFException {
        long startTimeValue;
        long endTimeValue = System.currentTimeMillis();
        if (startTime == null) {
            startTimeValue = endTimeValue - 1L;
        } else {
            startTimeValue = startTime;
            if (startTimeValue == endTimeValue) {
                --startTimeValue;
            }
        }
        long dataSizeValue = dataSize == null ? 0L : dataSize;
        Long rowID = this.historyManager.addRow(connectionName, startTimeValue, endTimeValue, dataSizeValue, activityType, entityIdentifier, resultCode, resultDescription);
    }

    @Override
    public long countHistoryRows(String connectionName, FilterCriteria criteria) throws ManifoldCFException {
        return this.historyManager.countHistoryRows(connectionName, criteria);
    }

    @Override
    public long getMaxRows() throws ManifoldCFException {
        return this.historyManager.getMaxRows();
    }

    @Override
    public IResultSet genHistorySimple(String connectionName, FilterCriteria criteria, SortOrder sort, int startRow, int maxRowCount) throws ManifoldCFException {
        return this.historyManager.simpleReport(connectionName, criteria, sort, startRow, maxRowCount);
    }

    @Override
    public IResultSet genHistoryActivityCount(String connectionName, FilterCriteria criteria, SortOrder sort, BucketDescription idBucket, long interval, int startRow, int maxRowCount) throws ManifoldCFException {
        return this.historyManager.maxActivityCountReport(connectionName, criteria, sort, idBucket, interval, startRow, maxRowCount);
    }

    @Override
    public IResultSet genHistoryByteCount(String connectionName, FilterCriteria criteria, SortOrder sort, BucketDescription idBucket, long interval, int startRow, int maxRowCount) throws ManifoldCFException {
        return this.historyManager.maxByteCountReport(connectionName, criteria, sort, idBucket, interval, startRow, maxRowCount);
    }

    @Override
    public IResultSet genHistoryResultCodes(String connectionName, FilterCriteria criteria, SortOrder sort, BucketDescription resultCodeBucket, BucketDescription idBucket, int startRow, int maxRowCount) throws ManifoldCFException {
        return this.historyManager.resultCodesReport(connectionName, criteria, sort, resultCodeBucket, idBucket, startRow, maxRowCount);
    }

    protected static String getRepositoryConnectionsKey() {
        return CacheKeyFactory.makeRepositoryConnectionsKey();
    }

    protected static String getRepositoryConnectionKey(String connectionName) {
        return CacheKeyFactory.makeRepositoryConnectionKey(connectionName);
    }

    protected RepositoryConnection[] getRepositoryConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        RepositoryConnection[] rval = new RepositoryConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.maxClauseGetRepositoryConnectionsChunk();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getRepositoryConnectionsChunk(rval, returnIndex, params);
                    params.clear();
                    j = 0;
                }
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getRepositoryConnectionsChunk(rval, returnIndex, params);
            }
            RepositoryConnection[] repositoryConnectionArray = rval;
            return repositoryConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected int maxClauseGetRepositoryConnectionsChunk() {
        return Math.min(this.findConjunctionClauseMax(new ClauseDescription[0]), this.throttleSpecManager.maxClauseGetRows());
    }

    protected void getRepositoryConnectionsChunk(RepositoryConnection[] rval, Map returnIndex, ArrayList params) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(nameField, (List)params)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            RepositoryConnection rc = new RepositoryConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setACLAuthority((String)row.getValue(groupNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
        this.throttleSpecManager.getRows(rval, returnIndex, params);
    }

    protected static class RepositoryConnectionExecutor
    extends ExecutorBase {
        protected RepositoryConnectionManager thisManager;
        protected RepositoryConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public RepositoryConnectionExecutor(RepositoryConnectionManager manager, RepositoryConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new RepositoryConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public RepositoryConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                RepositoryConnectionDescription desc = (RepositoryConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getRepositoryConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            RepositoryConnectionDescription objectDesc = (RepositoryConnectionDescription)objectDescription;
            RepositoryConnection ci = (RepositoryConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class RepositoryConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public RepositoryConnectionDescription(String connectionName, StringSet invKeys) {
            super("repositoryconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RepositoryConnectionDescription)) {
                return false;
            }
            RepositoryConnectionDescription d = (RepositoryConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

