/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.LaxBrowserCompatSpec;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.DeflateInputStream;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.interfaces.BreakException;
import org.apache.manifoldcf.connectorcommon.interfaces.IBreakCheck;
import org.apache.manifoldcf.connectorcommon.interfaces.IConnectionThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IFetchThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.IStreamThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IThrottleGroups;
import org.apache.manifoldcf.connectorcommon.interfaces.IThrottleSpec;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.ThrottleGroupsFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.webcrawler.AbortChecker;
import org.apache.manifoldcf.crawler.connectors.webcrawler.CookieSet;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormData;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormDataElement;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IThrottledConnection;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginCookies;
import org.apache.manifoldcf.crawler.connectors.webcrawler.PageCredentials;
import org.apache.manifoldcf.crawler.interfaces.IAbortActivity;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class ThrottledFetcher {
    public static final String _rcsid = "@(#)$Id: ThrottledFetcher.java 989847 2010-08-26 17:52:30Z kwright $";
    protected static final String webThrottleGroupType = "_WEB_";
    protected static final long idleTimeout = 300000L;
    protected static final boolean recordEverything = false;
    protected static final long TIME_2HRS = 0x6DDD00L;
    protected static final long TIME_5MIN = 300000L;
    protected static final long TIME_15MIN = 1500000L;
    protected static final long TIME_6HRS = 21600000L;
    protected static final long TIME_1DAY = 86400000L;
    protected static final int READ_CHUNK_LENGTH = 4096;
    protected static final Map<ConnectionPoolKey, ConnectionPool> connectionPools = new HashMap<ConnectionPoolKey, ConnectionPool>();
    private static String currentHost = null;
    private static final Registry<CookieSpecProvider> cookieSpecRegistry;

    private ThrottledFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IThrottledConnection getConnection(IThreadContext threadContext, String throttleGroupName, String protocol, String server, int port, PageCredentials authentication, IKeystoreManager trustStore, IThrottleSpec throttleDescription, String[] binNames, int connectionLimit, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, int socketTimeoutMilliseconds, int connectionTimeoutMilliseconds, IAbortActivity activities) throws ManifoldCFException, ServiceInterruption {
        ConnectionPool p;
        String trustStoreString;
        SSLSocketFactory baseFactory;
        IThrottleGroups throttleGroups = ThrottleGroupsFactory.make((IThreadContext)threadContext);
        throttleGroups.createOrUpdateThrottleGroup(webThrottleGroupType, throttleGroupName, throttleDescription);
        if (trustStore != null) {
            baseFactory = trustStore.getSecureSocketFactory();
            trustStoreString = trustStore.getHashString();
        } else {
            baseFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
            trustStoreString = null;
        }
        ConnectionPoolKey poolKey = new ConnectionPoolKey(protocol, server, port, authentication, trustStoreString, proxyHost, proxyPort, proxyAuthDomain, proxyAuthUsername, proxyAuthPassword, socketTimeoutMilliseconds, connectionTimeoutMilliseconds);
        Map<ConnectionPoolKey, ConnectionPool> map = connectionPools;
        synchronized (map) {
            p = connectionPools.get(poolKey);
            if (p == null) {
                IConnectionThrottler connectionThrottler = throttleGroups.obtainConnectionThrottler(webThrottleGroupType, throttleGroupName, binNames);
                p = new ConnectionPool(connectionThrottler, protocol, server, port, authentication, baseFactory, proxyHost, proxyPort, proxyAuthDomain, proxyAuthUsername, proxyAuthPassword, socketTimeoutMilliseconds, connectionTimeoutMilliseconds);
                connectionPools.put(poolKey, p);
            }
        }
        return p.grab(activities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushIdleConnections(IThreadContext threadContext) throws ManifoldCFException {
        Map<ConnectionPoolKey, ConnectionPool> map = connectionPools;
        synchronized (map) {
            for (ConnectionPool pool : connectionPools.values()) {
                pool.flushIdleConnections();
            }
        }
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        cookieSpecRegistry = RegistryBuilder.create().register("standard", (Object)new LaxBrowserCompatSpecProvider()).build();
    }

    protected static class ConnectionPool {
        protected final IConnectionThrottler connectionThrottler;
        protected final String protocol;
        protected final String server;
        protected final int port;
        protected final PageCredentials authentication;
        protected final SSLSocketFactory baseFactory;
        protected final String proxyHost;
        protected final int proxyPort;
        protected final String proxyAuthDomain;
        protected final String proxyAuthUsername;
        protected final String proxyAuthPassword;
        protected final int socketTimeoutMilliseconds;
        protected final int connectionTimeoutMilliseconds;
        protected final List<IThrottledConnection> connections = new ArrayList<IThrottledConnection>();

        public ConnectionPool(IConnectionThrottler connectionThrottler, String protocol, String server, int port, PageCredentials authentication, SSLSocketFactory baseFactory, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, int socketTimeoutMilliseconds, int connectionTimeoutMilliseconds) {
            this.connectionThrottler = connectionThrottler;
            this.protocol = protocol;
            this.server = server;
            this.port = port;
            this.authentication = authentication;
            this.baseFactory = baseFactory;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyAuthDomain = proxyAuthDomain;
            this.proxyAuthUsername = proxyAuthUsername;
            this.proxyAuthPassword = proxyAuthPassword;
            this.socketTimeoutMilliseconds = socketTimeoutMilliseconds;
            this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IThrottledConnection grab(IAbortActivity activities) throws ManifoldCFException, ServiceInterruption {
            AbortChecker abortCheck = new AbortChecker(activities);
            try {
                IThrottledConnection connection;
                int result = this.connectionThrottler.waitConnectionAvailable((IBreakCheck)abortCheck);
                if (result == 0) {
                    List<IThrottledConnection> list = this.connections;
                    synchronized (list) {
                        connection = this.connections.remove(this.connections.size() - 1);
                    }
                } else if (result == 1) {
                    connection = new ThrottledConnection(this, this.connectionThrottler.getNewConnectionFetchThrottler(), this.protocol, this.server, this.port, this.authentication, this.baseFactory, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword, this.socketTimeoutMilliseconds, this.connectionTimeoutMilliseconds);
                } else {
                    throw new IllegalStateException("Unexpected return value from waitConnectionAvailable(): " + result);
                }
                connection.setAbortChecker(abortCheck);
                return connection;
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
            catch (BreakException e) {
                abortCheck.rethrowExceptions();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(IThrottledConnection connection) {
            if (this.connectionThrottler.noteReturnedConnection()) {
                connection.destroy();
                this.connectionThrottler.noteConnectionDestroyed();
            } else {
                connection.setAbortChecker(null);
                List<IThrottledConnection> list = this.connections;
                synchronized (list) {
                    this.connections.add(connection);
                }
                this.connectionThrottler.noteConnectionReturnedToPool();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushIdleConnections() {
            List<IThrottledConnection> list;
            long currentTime = System.currentTimeMillis();
            while (this.connectionThrottler.checkDestroyPooledConnection()) {
                IThrottledConnection connection;
                list = this.connections;
                synchronized (list) {
                    connection = this.connections.remove(0);
                }
                connection.destroy();
                this.connectionThrottler.noteConnectionDestroyed();
            }
            while (true) {
                IThrottledConnection connection;
                boolean expired;
                list = this.connections;
                synchronized (list) {
                    expired = this.connections.size() > 0 && this.connections.get(0).hasExpired(currentTime);
                }
                if (!expired || !this.connectionThrottler.checkExpireConnection()) break;
                List<IThrottledConnection> list2 = this.connections;
                synchronized (list2) {
                    connection = this.connections.remove(0);
                }
                connection.destroy();
                this.connectionThrottler.noteConnectionDestroyed();
            }
        }
    }

    protected static class ConnectionPoolKey {
        protected final String protocol;
        protected final String server;
        protected final int port;
        protected final PageCredentials authentication;
        protected final String trustStoreString;
        protected final String proxyHost;
        protected final int proxyPort;
        protected final String proxyAuthDomain;
        protected final String proxyAuthUsername;
        protected final String proxyAuthPassword;
        protected final int socketTimeoutMilliseconds;
        protected final int connectionTimeoutMilliseconds;

        public ConnectionPoolKey(String protocol, String server, int port, PageCredentials authentication, String trustStoreString, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, int socketTimeoutMilliseconds, int connectionTimeoutMilliseconds) {
            this.protocol = protocol;
            this.server = server;
            this.port = port;
            this.authentication = authentication;
            this.trustStoreString = trustStoreString;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyAuthDomain = proxyAuthDomain;
            this.proxyAuthUsername = proxyAuthUsername;
            this.proxyAuthPassword = proxyAuthPassword;
            this.socketTimeoutMilliseconds = socketTimeoutMilliseconds;
            this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
        }

        public int hashCode() {
            return this.protocol.hashCode() + this.server.hashCode() + this.port * 31 + (this.authentication == null ? 0 : this.authentication.hashCode()) + (this.trustStoreString == null ? 0 : this.trustStoreString.hashCode()) + (this.proxyHost == null ? 0 : this.proxyHost.hashCode()) + this.proxyPort * 29 + (this.proxyAuthDomain == null ? 0 : this.proxyAuthDomain.hashCode()) + (this.proxyAuthUsername == null ? 0 : this.proxyAuthUsername.hashCode()) + (this.proxyAuthPassword == null ? 0 : this.proxyAuthPassword.hashCode()) + new Integer(this.socketTimeoutMilliseconds).hashCode() + new Integer(this.connectionTimeoutMilliseconds).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionPoolKey)) {
                return false;
            }
            ConnectionPoolKey other = (ConnectionPoolKey)o;
            if (!this.server.equals(other.server) || this.port != other.port) {
                return false;
            }
            if (this.authentication == null || other.authentication == null ? this.authentication != other.authentication : !this.authentication.equals(other.authentication)) {
                return false;
            }
            if (this.trustStoreString == null || other.trustStoreString == null ? this.trustStoreString != other.trustStoreString : !this.trustStoreString.equals(other.trustStoreString)) {
                return false;
            }
            if (this.proxyHost == null || other.proxyHost == null ? this.proxyHost != other.proxyHost : !this.proxyHost.equals(other.proxyHost)) {
                return false;
            }
            if (this.proxyPort != other.proxyPort) {
                return false;
            }
            if (this.proxyAuthDomain == null || other.proxyAuthDomain == null ? this.proxyAuthDomain != other.proxyAuthDomain : !this.proxyAuthDomain.equals(other.proxyAuthDomain)) {
                return false;
            }
            if (this.proxyAuthUsername == null || other.proxyAuthUsername == null ? this.proxyAuthUsername != other.proxyAuthUsername : !this.proxyAuthUsername.equals(other.proxyAuthUsername)) {
                return false;
            }
            if (this.proxyAuthPassword == null || other.proxyAuthPassword == null ? this.proxyAuthPassword != other.proxyAuthPassword : !this.proxyAuthPassword.equals(other.proxyAuthPassword)) {
                return false;
            }
            return this.socketTimeoutMilliseconds == other.socketTimeoutMilliseconds && this.connectionTimeoutMilliseconds == other.connectionTimeoutMilliseconds;
        }
    }

    protected static class OurBasicCookieStore
    implements CookieStore,
    Serializable {
        private static final long serialVersionUID = -7581093305228232025L;
        private final TreeSet<Cookie> cookies = new TreeSet(new CookieIdentityComparator());

        public synchronized void addCookie(Cookie cookie) {
            if (cookie != null) {
                this.cookies.remove(cookie);
                this.cookies.add(cookie);
            }
        }

        public synchronized void addCookies(Cookie[] cookies) {
            if (cookies != null) {
                for (Cookie cooky : cookies) {
                    this.addCookie(cooky);
                }
            }
        }

        public synchronized List<Cookie> getCookies() {
            return new ArrayList<Cookie>(this.cookies);
        }

        public synchronized boolean clearExpired(Date date) {
            if (date == null) {
                return false;
            }
            boolean removed = false;
            Iterator<Cookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                if (!it.next().isExpired(date)) continue;
                it.remove();
                removed = true;
            }
            return removed;
        }

        public synchronized void clear() {
            this.cookies.clear();
        }

        public synchronized String toString() {
            return this.cookies.toString();
        }
    }

    protected static class ExecuteMethodThread
    extends Thread {
        protected final ThrottledConnection theConnection;
        protected final IFetchThrottler fetchThrottler;
        protected final HttpClient httpClient;
        protected final HttpHost target;
        protected final HttpRequestBase executeMethod;
        protected final CookieStore cookieStore;
        protected HttpResponse response = null;
        protected Throwable responseException = null;
        protected LoginCookies cookies = null;
        protected Throwable cookieException = null;
        protected XThreadInputStream threadStream = null;
        protected InputStream bodyStream = null;
        protected boolean streamCreated = false;
        protected Throwable streamException = null;
        protected boolean abortThread = false;
        protected boolean gzip = false;
        protected boolean deflate = false;
        protected Throwable shutdownException = null;
        protected Throwable generalException = null;

        public ExecuteMethodThread(ThrottledConnection theConnection, IFetchThrottler fetchThrottler, HttpClient httpClient, HttpHost target, HttpRequestBase executeMethod, CookieStore cookieStore) {
            this.setDaemon(true);
            this.theConnection = theConnection;
            this.fetchThrottler = fetchThrottler;
            this.httpClient = httpClient;
            this.target = target;
            this.executeMethod = executeMethod;
            this.cookieStore = cookieStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ExecuteMethodThread executeMethodThread;
                try {
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        if (!this.abortThread) {
                            try {
                                BasicHttpContext context = new BasicHttpContext();
                                context.setAttribute("http.cookie-store", (Object)this.cookieStore);
                                this.response = this.httpClient.execute(this.target, (HttpRequest)this.executeMethod, (HttpContext)context);
                            }
                            catch (SocketTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (ConnectTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (InterruptedIOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                this.responseException = e;
                            }
                            this.notifyAll();
                        }
                    }
                    if (this.responseException == null) {
                        executeMethodThread = this;
                        synchronized (executeMethodThread) {
                            if (!this.abortThread) {
                                try {
                                    this.cookies = new CookieSet(this.cookieStore.getCookies());
                                }
                                catch (Throwable e) {
                                    this.cookieException = e;
                                }
                                this.notifyAll();
                            }
                        }
                    }
                    if (this.cookieException == null && this.responseException == null) {
                        executeMethodThread = this;
                        synchronized (executeMethodThread) {
                            if (!this.abortThread) {
                                try {
                                    Header ceheader = this.response.getEntity().getContentEncoding();
                                    if (ceheader != null) {
                                        HeaderElement[] codecs = ceheader.getElements();
                                        for (int i = 0; i < codecs.length; ++i) {
                                            if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                                                this.gzip = true;
                                                break;
                                            }
                                            if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                                            this.deflate = true;
                                            break;
                                        }
                                    }
                                    this.bodyStream = this.response.getEntity().getContent();
                                    if (this.bodyStream != null) {
                                        this.bodyStream = new ThrottledInputstream(this.fetchThrottler.createFetchStream(), this.theConnection, this.bodyStream);
                                        this.threadStream = new XThreadInputStream(this.bodyStream);
                                    }
                                    this.streamCreated = true;
                                }
                                catch (SocketTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (ConnectTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (InterruptedIOException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    this.streamException = e;
                                }
                                this.notifyAll();
                            }
                        }
                    }
                    if (this.cookieException == null && this.responseException == null && this.streamException == null && this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.bodyStream != null) {
                        try {
                            this.bodyStream.close();
                        }
                        catch (IOException iOException) {}
                        this.bodyStream = null;
                    }
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        try {
                            this.executeMethod.abort();
                        }
                        catch (Throwable e) {
                            this.shutdownException = e;
                        }
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable e) {
                this.generalException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResponseCode() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        return this.response.getStatusLine().getStatusCode();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, List<String>> getResponseHeaders() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header[] headers = this.response.getAllHeaders();
                        HashMap<String, List<String>> rval = new HashMap<String, List<String>>();
                        int i = 0;
                        while (i < headers.length) {
                            Header h = headers[i++];
                            String name = h.getName();
                            String value = h.getValue();
                            ArrayList<String> values = (ArrayList<String>)rval.get(name);
                            if (values == null) {
                                values = new ArrayList<String>();
                                rval.put(name, values);
                            }
                            values.add(value);
                        }
                        return rval;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFirstHeader(String headerName) throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header h = this.response.getFirstHeader(headerName);
                        if (h == null) {
                            return null;
                        }
                        return h.getValue();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoginCookies getCookies() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting cookies");
                    }
                    this.checkException(this.cookieException);
                    if (this.cookies != null) {
                        return this.cookies;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isGZipStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    if (this.cookieException != null) {
                        throw new IllegalStateException("Check for cookies before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.gzip;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDeflateStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    if (this.cookieException != null) {
                        throw new IllegalStateException("Check for cookies before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.deflate;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    if (this.cookieException != null) {
                        throw new IllegalStateException("Check for cookies before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ExecuteMethodThread executeMethodThread = this;
            synchronized (executeMethodThread) {
                if (this.streamCreated && this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
        }

        public void finishUp() throws InterruptedException {
            this.join();
        }

        protected synchronized void checkException(Throwable exception) throws IOException, HttpException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof HttpException) {
                    throw (HttpException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    protected static class LaxBrowserCompatSpecProvider
    extends RFC6265CookieSpecProvider {
        protected LaxBrowserCompatSpecProvider() {
        }

        public CookieSpec create(HttpContext context) {
            return new LaxBrowserCompatSpec();
        }
    }

    protected static class WaitException
    extends Exception {
        protected long amt;

        public WaitException(long amt) {
            super("Wait needed");
            this.amt = amt;
        }

        public long getWaitAmount() {
            return this.amt;
        }
    }

    protected static class PoolException
    extends Exception {
        public PoolException(String message) {
            super(message);
        }
    }

    protected static class ThrottledInputstream
    extends InputStream {
        protected final IStreamThrottler streamThrottler;
        protected final ThrottledConnection throttledConnection;
        protected final InputStream inputStream;

        public ThrottledInputstream(IStreamThrottler streamThrottler, ThrottledConnection connection, InputStream is) {
            this.streamThrottler = streamThrottler;
            this.throttledConnection = connection;
            this.inputStream = is;
        }

        @Override
        public int read() throws IOException {
            byte[] byteArray = new byte[1];
            int count = this.read(byteArray, 0, 1);
            if (count == -1) {
                return count;
            }
            return byteArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int amt;
            int totalCount = 0;
            while (len > 4096) {
                amt = this.basicRead(b, off, 4096, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                totalCount += amt;
                off += amt;
                len -= amt;
            }
            if (len > 0) {
                amt = this.basicRead(b, off, len, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                return totalCount + amt;
            }
            return totalCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int basicRead(byte[] b, int off, int len, int totalSoFar) throws IOException {
            int n;
            block9: {
                int amt;
                block8: {
                    if (!this.streamThrottler.obtainReadPermission(len)) {
                        throw new IllegalStateException("Unexpected result calling obtainReadPermission()");
                    }
                    amt = 0;
                    try {
                        n = amt = this.inputStream.read(b, off, len);
                        if (amt != -1) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (amt == -1) {
                                this.streamThrottler.releaseReadPermission(len, 0);
                            } else {
                                this.streamThrottler.releaseReadPermission(len, amt);
                                this.throttledConnection.logFetchCount(amt);
                            }
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            InterruptedIOException e2 = new InterruptedIOException("Interrupted");
                            e2.bytesTransferred = totalSoFar;
                            throw e2;
                        }
                    }
                    this.streamThrottler.releaseReadPermission(len, 0);
                    break block9;
                }
                this.streamThrottler.releaseReadPermission(len, amt);
                this.throttledConnection.logFetchCount(amt);
            }
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void mark(int readLimit) {
            this.inputStream.mark(readLimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        @Override
        public void close() throws IOException {
            try {
                this.inputStream.close();
            }
            catch (SocketTimeoutException e) {
                Logging.connectors.debug((Object)("Socket timeout exception trying to close connection: " + e.getMessage()), (Throwable)e);
            }
            catch (ConnectTimeoutException e) {
                Logging.connectors.debug((Object)("Socket connection timeout exception trying to close connection: " + e.getMessage()), (Throwable)e);
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (SocketException e) {
                Logging.connectors.debug((Object)("Connection reset while I was closing it: " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                Logging.connectors.debug((Object)("IO Exception trying to close connection: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.streamThrottler.closeStream();
            }
        }
    }

    protected static class ThrottledConnection
    implements IThrottledConnection {
        protected final ConnectionPool myPool;
        protected final IFetchThrottler fetchThrottler;
        protected final String protocol;
        protected final String server;
        protected final int port;
        protected final PageCredentials authentication;
        protected long expireTime = -1L;
        protected HttpClientConnectionManager connManager = null;
        protected HttpClient httpClient = null;
        protected HttpRequestBase fetchMethod = null;
        protected Throwable throwable = null;
        protected String myUrl = null;
        protected int statusCode = -1;
        protected String fetchType = null;
        protected long fetchCounter = 0L;
        protected long startFetchTime = -1L;
        protected LoginCookies lastFetchCookies = null;
        protected final String proxyHost;
        protected final int proxyPort;
        protected final String proxyAuthDomain;
        protected final String proxyAuthUsername;
        protected final String proxyAuthPassword;
        protected final SSLSocketFactory httpsSocketFactory;
        protected final int socketTimeoutMilliseconds;
        protected final int connectionTimeoutMilliseconds;
        protected ExecuteMethodThread methodThread = null;
        protected boolean threadStarted = false;
        protected AbortChecker abortCheck = null;

        public ThrottledConnection(ConnectionPool myPool, IFetchThrottler fetchThrottler, String protocol, String server, int port, PageCredentials authentication, SSLSocketFactory httpsSocketFactory, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword, int socketTimeoutMilliseconds, int connectionTimeoutMilliseconds) {
            this.myPool = myPool;
            this.fetchThrottler = fetchThrottler;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyAuthDomain = proxyAuthDomain;
            this.proxyAuthUsername = proxyAuthUsername;
            this.proxyAuthPassword = proxyAuthPassword;
            this.protocol = protocol;
            this.server = server;
            this.port = port;
            this.authentication = authentication;
            this.httpsSocketFactory = httpsSocketFactory;
            this.socketTimeoutMilliseconds = socketTimeoutMilliseconds;
            this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
        }

        @Override
        public void setAbortChecker(AbortChecker abortCheck) {
            this.abortCheck = abortCheck;
        }

        @Override
        public boolean hasExpired(long currentTime) {
            if (this.connManager != null) {
                this.connManager.closeIdleConnections(300000L, TimeUnit.MILLISECONDS);
                this.connManager.closeExpiredConnections();
            }
            return currentTime > this.expireTime;
        }

        public void logFetchCount(int count) {
            this.fetchCounter += (long)count;
        }

        @Override
        public void destroy() {
            if (this.connManager != null) {
                this.connManager.shutdown();
                this.connManager = null;
            }
        }

        @Override
        public void beginFetch(String fetchType) throws ManifoldCFException, ServiceInterruption {
            this.fetchType = fetchType;
            this.fetchCounter = 0L;
            try {
                if (!this.fetchThrottler.obtainFetchDocumentPermission((IBreakCheck)this.abortCheck)) {
                    throw new IllegalStateException("Unexpected return value from obtainFetchDocumentPermission()");
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            catch (BreakException e) {
                this.abortCheck.rethrowExceptions();
            }
        }

        @Override
        public void executeFetch(String urlPath, String userAgent, String from, boolean redirectOK, String host, FormData formData, LoginCookies loginCookies) throws ManifoldCFException, ServiceInterruption {
            HttpHost hostHost;
            int hostPort;
            Object displayedPort;
            SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(this.httpsSocketFactory, (long)this.connectionTimeoutMilliseconds), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            if (this.port != -1) {
                if (!(this.protocol.equals("http") && this.port == 80 || this.protocol.equals("https") && this.port == 443)) {
                    displayedPort = ":" + Integer.toString(this.port);
                    hostPort = this.port;
                } else {
                    displayedPort = "";
                    hostPort = -1;
                }
            } else {
                displayedPort = "";
                hostPort = -1;
            }
            StringBuilder sb = new StringBuilder(this.protocol);
            sb.append("://").append(this.server).append((String)displayedPort).append(urlPath);
            String fetchUrl = sb.toString();
            HttpHost fetchHost = new HttpHost(this.server, hostPort, this.protocol);
            if (host != null) {
                sb.setLength(0);
                sb.append(this.protocol).append("://").append(host).append((String)displayedPort).append(urlPath);
                this.myUrl = sb.toString();
                hostHost = new HttpHost(host, hostPort, this.protocol);
            } else {
                this.myUrl = fetchUrl;
                hostHost = fetchHost;
            }
            if (this.connManager == null) {
                PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
                poolingConnManager.setDefaultMaxPerRoute(1);
                poolingConnManager.setValidateAfterInactivity(2000);
                poolingConnManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.socketTimeoutMilliseconds).build());
                this.connManager = poolingConnManager;
            }
            long startTime = 0L;
            if (Logging.connectors.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                Logging.connectors.debug((Object)"WEB: Waiting for an HttpClient object");
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.authentication != null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: For " + this.myUrl + ", discovered matching authentication credentials"));
                }
                credentialsProvider.setCredentials(AuthScope.ANY, this.authentication.makeCredentialsObject(host));
            }
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(this.socketTimeoutMilliseconds).setExpectContinueEnabled(true).setConnectTimeout(this.connectionTimeoutMilliseconds).setConnectionRequestTimeout(this.socketTimeoutMilliseconds).setCookieSpec("standard").setRedirectsEnabled(redirectOK);
            if (this.proxyHost != null && this.proxyHost.length() > 0) {
                if (this.proxyAuthUsername != null && this.proxyAuthUsername.length() > 0) {
                    credentialsProvider.setCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)new NTCredentials(this.proxyAuthUsername, this.proxyAuthPassword == null ? "" : this.proxyAuthPassword, currentHost, this.proxyAuthDomain == null ? "" : this.proxyAuthDomain));
                }
                HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
                requestBuilder.setProxy(proxy);
            }
            this.httpClient = HttpClients.custom().setConnectionManager(this.connManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(this.socketTimeoutMilliseconds)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            if (host != null && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: For " + this.myUrl + ", setting virtual host to " + host));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Got an HttpClient object after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
            }
            this.startFetchTime = System.currentTimeMillis();
            int pageFetchMethod = 0;
            if (formData != null) {
                pageFetchMethod = formData.getSubmitMethod();
            }
            switch (pageFetchMethod) {
                case 0: {
                    String fullUrlPath;
                    String value;
                    String param;
                    if (formData != null) {
                        StringBuilder psb = new StringBuilder(urlPath);
                        Iterator iter = formData.getElementIterator();
                        int appendChar = urlPath.indexOf("?") == -1 ? 63 : 38;
                        while (iter.hasNext()) {
                            FormDataElement el = (FormDataElement)iter.next();
                            psb.append((char)appendChar);
                            appendChar = 38;
                            param = el.getElementName();
                            value = el.getElementValue();
                            psb.append(URLEncoder.encode((String)param));
                            if (value == null) continue;
                            psb.append('=').append(URLEncoder.encode((String)value));
                        }
                        fullUrlPath = psb.toString();
                    } else {
                        fullUrlPath = urlPath;
                    }
                    while (fullUrlPath.startsWith("//")) {
                        fullUrlPath = fullUrlPath.substring(1);
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: Get method for '" + fullUrlPath + "'"));
                    }
                    this.fetchMethod = new HttpGet(fullUrlPath);
                    break;
                }
                case 1: {
                    String value;
                    String param;
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: Post method for '" + urlPath + "'"));
                    }
                    HttpPost postMethod = new HttpPost(urlPath);
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    if (formData != null) {
                        Iterator iter = formData.getElementIterator();
                        while (iter.hasNext()) {
                            FormDataElement e = (FormDataElement)iter.next();
                            param = e.getElementName();
                            value = e.getElementValue();
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Post parameter name '" + param + "' value '" + value + "' for '" + urlPath + "'"));
                            }
                            nvps.add(new BasicNameValuePair(param, value));
                        }
                    }
                    postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
                    this.fetchMethod = postMethod;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Illegal method type: " + Integer.toString(pageFetchMethod));
                }
            }
            this.fetchMethod.setHeader((Header)new BasicHeader("User-Agent", userAgent));
            this.fetchMethod.setHeader((Header)new BasicHeader("From", from));
            this.fetchMethod.setHeader((Header)new BasicHeader("Accept", "*/*"));
            this.fetchMethod.setHeader((Header)new BasicHeader("Accept-Encoding", "gzip,deflate"));
            OurBasicCookieStore cookieStore = new OurBasicCookieStore();
            if (loginCookies != null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Adding " + Integer.toString(loginCookies.getCookieCount()) + " cookies for '" + urlPath + "'"));
                }
                int h = 0;
                while (h < loginCookies.getCookieCount()) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB:  Cookie '" + String.valueOf(loginCookies.getCookie(h)) + "' added"));
                    }
                    cookieStore.addCookie(loginCookies.getCookie(h++));
                }
            }
            this.lastFetchCookies = loginCookies;
            this.methodThread = new ExecuteMethodThread(this, this.fetchThrottler, this.httpClient, hostHost, this.fetchMethod, cookieStore);
            try {
                this.methodThread.start();
                this.threadStarted = true;
                try {
                    this.statusCode = this.methodThread.getResponseCode();
                    this.lastFetchCookies = this.methodThread.getCookies();
                    switch (this.statusCode) {
                        case 408: 
                        case 503: 
                        case 504: {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Http response temporary error on '" + this.myUrl + "': " + Integer.toString(this.statusCode), (Throwable)new ManifoldCFException("Service unavailable (code " + Integer.toString(this.statusCode) + ")"), currentTime + 0x6DDD00L, currentTime + 86400000L, -1, false);
                        }
                    }
                    return;
                }
                catch (InterruptedException e) {
                    this.methodThread.interrupt();
                    this.methodThread = null;
                    this.threadStarted = false;
                    throw e;
                }
            }
            catch (InterruptedException e) {
                this.fetchMethod = null;
                this.throwable = new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e);
                this.statusCode = -104;
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (SocketTimeoutException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for IO for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for connection for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (InterruptedIOException e) {
                this.throwable = new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e);
                this.statusCode = -104;
                throw new ManifoldCFException("Interrupted", 2);
            }
            catch (RedirectException e) {
                this.throwable = e;
                this.statusCode = -100;
                return;
            }
            catch (NoHttpResponseException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for response for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 1500000L, currentTime + 0x6DDD00L, -1, false);
            }
            catch (ConnectException e) {
                this.throwable = e;
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out waiting for a connection for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 0x6DDD00L, currentTime + 21600000L, -1, false);
            }
            catch (SSLException e) {
                this.throwable = new ManifoldCFException("SSL handshake error: " + e.getMessage() + "; check your connection's Certificate configuration", (Throwable)e);
                this.statusCode = -103;
                return;
            }
            catch (IOException e) {
                this.throwable = e;
                this.statusCode = -103;
                return;
            }
            catch (Throwable e) {
                Logging.connectors.debug((Object)("WEB: Caught an unexpected exception: " + e.getMessage()), e);
                this.throwable = e;
                this.statusCode = -999;
                return;
            }
        }

        @Override
        public int getResponseCode() throws ManifoldCFException, ServiceInterruption {
            return this.statusCode;
        }

        @Override
        public LoginCookies getLastFetchCookies() throws ManifoldCFException, ServiceInterruption {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)"WEB: Retrieving cookies...");
                for (int i = 0; i < this.lastFetchCookies.getCookieCount(); ++i) {
                    Logging.connectors.debug((Object)("WEB:   Cookie '" + String.valueOf(this.lastFetchCookies.getCookie(i)) + "'"));
                }
            }
            return this.lastFetchCookies;
        }

        @Override
        public Map<String, List<String>> getResponseHeaders() throws ManifoldCFException, ServiceInterruption {
            if (this.fetchMethod == null) {
                throw new ManifoldCFException("Attempt to get headers when there is no method");
            }
            if (this.methodThread == null || !this.threadStarted) {
                throw new ManifoldCFException("Attempt to get headers when no method thread");
            }
            try {
                return this.methodThread.getResponseHeaders();
            }
            catch (InterruptedException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (HttpException e) {
                this.handleHTTPException(e, "reading headers");
            }
            catch (IOException e) {
                this.handleIOException(e, "reading headers");
            }
            return null;
        }

        @Override
        public String getResponseHeader(String headerName) throws ManifoldCFException, ServiceInterruption {
            if (this.fetchMethod == null) {
                throw new ManifoldCFException("Attempt to get a header when there is no method");
            }
            if (this.methodThread == null || !this.threadStarted) {
                throw new ManifoldCFException("Attempt to get a header when no method thread");
            }
            try {
                return this.methodThread.getFirstHeader(headerName);
            }
            catch (InterruptedException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (HttpException e) {
                this.handleHTTPException(e, "reading header");
            }
            catch (IOException e) {
                this.handleIOException(e, "reading header");
            }
            return null;
        }

        @Override
        public InputStream getResponseBodyStream() throws ManifoldCFException, ServiceInterruption {
            if (this.fetchMethod == null) {
                throw new ManifoldCFException("Attempt to get an input stream when there is no method");
            }
            if (this.methodThread == null || !this.threadStarted) {
                throw new ManifoldCFException("Attempt to get an input stream when no method thread");
            }
            try {
                InputStream bodyStream = this.methodThread.getSafeInputStream();
                if (this.methodThread.isGZipStream()) {
                    bodyStream = new GZIPInputStream(bodyStream);
                } else if (this.methodThread.isDeflateStream()) {
                    bodyStream = new DeflateInputStream(bodyStream);
                }
                return bodyStream;
            }
            catch (InterruptedException e) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                this.handleIOException(e, "reading response stream");
            }
            catch (HttpException e) {
                this.handleHTTPException(e, "reading response stream");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getLimitedResponseBody(int maxSize, String encoding) throws ManifoldCFException, ServiceInterruption {
            try (InputStream is = this.getResponseBodyStream();){
                InputStreamReader r = new InputStreamReader(is, encoding);
                char[] buffer = new char[maxSize];
                int amt = r.read(buffer);
                if (amt == -1) {
                    String string = "";
                    return string;
                }
                String string = new String(buffer, 0, amt);
                return string;
            }
            catch (IOException e) {
                this.handleIOException(e, "reading limited response");
                return null;
            }
        }

        @Override
        public void noteInterrupted(Throwable e) {
            if (this.statusCode > 0) {
                this.throwable = new ManifoldCFException("Fetch interrupted: " + e.getMessage(), e);
                this.statusCode = -104;
            }
        }

        @Override
        public void doneFetch(IProcessActivity activities) throws ManifoldCFException {
            if (this.fetchType != null) {
                if (this.methodThread != null && this.threadStarted) {
                    this.methodThread.abort();
                }
                long endTime = System.currentTimeMillis();
                activities.recordActivity(new Long(this.startFetchTime), "fetch", new Long(this.fetchCounter), this.myUrl, Integer.toString(this.statusCode), this.throwable == null ? null : this.throwable.getMessage(), null);
                Logging.connectors.info((Object)("WEB: FETCH " + this.fetchType + "|" + this.myUrl + "|" + new Long(this.startFetchTime).toString() + "+" + new Long(endTime - this.startFetchTime).toString() + "|" + Integer.toString(this.statusCode) + "|" + new Long(this.fetchCounter).toString() + "|" + (String)(this.throwable == null ? "" : this.throwable.getClass().getName() + "| " + this.throwable.getMessage())));
                if (this.throwable != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Fetch exception for '" + this.myUrl + "'"), this.throwable);
                }
                if (this.methodThread != null) {
                    if (this.threadStarted) {
                        try {
                            this.methodThread.finishUp();
                        }
                        catch (InterruptedException e) {
                            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
                        }
                        this.threadStarted = false;
                    }
                    this.methodThread = null;
                }
                this.fetchMethod = null;
                this.throwable = null;
                this.startFetchTime = -1L;
                this.myUrl = null;
                this.statusCode = -1;
                this.lastFetchCookies = null;
                this.fetchType = null;
            }
        }

        @Override
        public void close() {
            this.expireTime = System.currentTimeMillis() + 300000L;
            this.myPool.release(this);
        }

        protected void handleHTTPException(HttpException e, String activity) throws ServiceInterruption, ManifoldCFException {
            long currentTime = System.currentTimeMillis();
            Logging.connectors.debug((Object)("Web: HTTP exception " + activity + " for '" + this.myUrl + "', retrying"));
            throw new ServiceInterruption("HTTP exception " + activity + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, -1L, 2, false);
        }

        protected void handleIOException(IOException e, String activity) throws ServiceInterruption, ManifoldCFException {
            if (e instanceof SocketTimeoutException) {
                long currentTime = System.currentTimeMillis();
                Logging.connectors.debug((Object)("Web: Socket timeout exception " + activity + " for '" + this.myUrl + "', retrying"));
                throw new ServiceInterruption("Socket timeout exception " + activity + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, -1L, 2, false);
            }
            if (e instanceof ConnectTimeoutException) {
                long currentTime = System.currentTimeMillis();
                Logging.connectors.debug((Object)("Web: Connect timeout exception " + activity + " for '" + this.myUrl + "', retrying"));
                throw new ServiceInterruption("Connect timeout exception " + activity + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, -1L, 2, false);
            }
            if (e instanceof InterruptedIOException) {
                this.methodThread.interrupt();
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (e instanceof NoHttpResponseException) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out " + activity + " for '" + this.myUrl + "'", (Throwable)e, currentTime + 900000L, currentTime + 0x6DDD00L, -1, false);
            }
            if (e instanceof ConnectException) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Timed out " + activity + " for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            if (e instanceof NoRouteToHostException) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("No route to host during " + activity + " for '" + this.myUrl + "'", (Throwable)e, currentTime + 1000000L, currentTime + 43200000L, -1, false);
            }
            long currentTime = System.currentTimeMillis();
            Logging.connectors.debug((Object)("Web: IO exception (" + e.getClass().getName() + ")" + activity + " for '" + this.myUrl + "', retrying"), (Throwable)e);
            throw new ServiceInterruption("IO exception (" + e.getClass().getName() + ")" + activity + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, -1L, 2, false);
        }
    }
}

