/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormData;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormItem;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;

public class FormDataAccumulator
implements FormData {
    protected static final int ELEMENTCATEGORY_FREEFORM = 0;
    protected static final int ELEMENTCATEGORY_FIXEDEXCLUSIVE = 1;
    protected static final int ELEMENTCATEGORY_FIXEDINCLUSIVE = 2;
    protected String actionURI;
    protected int submitMethod;
    protected ArrayList elementList = new ArrayList();

    public FormDataAccumulator(String actionURI, int submitMethod) {
        this.actionURI = actionURI;
        this.submitMethod = submitMethod;
    }

    public void addElement(Map attributes) {
        String name;
        String type = (String)attributes.get("type");
        if (type == null) {
            type = "text";
        }
        if ((name = (String)attributes.get("name")) != null) {
            String lowerType = type.toLowerCase(Locale.ROOT);
            if (lowerType.equals("submit")) {
                String value = (String)attributes.get("value");
                if (value == null) {
                    value = "Submit Form";
                }
                this.elementList.add(new FormItem(name, value, 0, true));
            } else if (lowerType.equals("hidden") || lowerType.equals("text") || lowerType.equals("password")) {
                String value = (String)attributes.get("value");
                if (value == null) {
                    value = "";
                }
                this.elementList.add(new FormItem(name, value, 0, true));
            } else if (lowerType.equals("select")) {
                String value = (String)attributes.get("value");
                if (value == null) {
                    value = "";
                }
                String selected = (String)attributes.get("selected");
                boolean isSelected = false;
                if (selected != null) {
                    isSelected = true;
                }
                String multiple = (String)attributes.get("multiple");
                boolean isMultiple = false;
                if (multiple != null) {
                    isMultiple = true;
                }
                this.elementList.add(new FormItem(name, value, isMultiple ? 2 : 1, isSelected));
            } else if (lowerType.equals("radio")) {
                String value = (String)attributes.get("value");
                if (value == null) {
                    value = "";
                }
                String selected = (String)attributes.get("checked");
                boolean isSelected = false;
                if (selected != null) {
                    isSelected = true;
                }
                this.elementList.add(new FormItem(name, value, 1, isSelected));
            } else if (lowerType.equals("checkbox")) {
                String value = (String)attributes.get("value");
                if (value == null) {
                    value = "";
                }
                String selected = (String)attributes.get("checked");
                boolean isSelected = false;
                if (selected != null) {
                    isSelected = true;
                }
                this.elementList.add(new FormItem(name, value, 2, isSelected));
            } else if (lowerType.equals("textarea")) {
                this.elementList.add(new FormItem(name, "", 0, true));
            }
        }
    }

    public void overrideActionURI(String overrideURI) {
        this.actionURI = overrideURI;
    }

    public void applyOverrides(LoginParameters lp) {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        int i = 0;
        while (i < lp.getParameterCount()) {
            Pattern namePattern = lp.getParameterNamePattern(i);
            String value = lp.getParameterValue(i);
            ++i;
            int j = 0;
            while (j < this.elementList.size()) {
                FormItem fi;
                Matcher m;
                if (!(m = namePattern.matcher((fi = (FormItem)this.elementList.get(j++)).getElementName())).find()) continue;
                switch (fi.getType()) {
                    case 0: {
                        fi.setValue(value);
                        break;
                    }
                    case 1: {
                        fi.setEnabled(fi.getElementValue().equals(value));
                        break;
                    }
                    case 2: {
                        if (overrideMap.get(fi.getElementName()) == null) {
                            int k = 0;
                            while (k < this.elementList.size()) {
                                FormItem fi2;
                                if (!(fi2 = (FormItem)this.elementList.get(k++)).getElementName().equals(fi.getElementName())) continue;
                                fi.setEnabled(false);
                            }
                            overrideMap.put(fi.getElementName(), fi.getElementName());
                        }
                        if (!fi.getElementValue().equals(value)) break;
                        fi.setEnabled(true);
                    }
                }
            }
        }
    }

    @Override
    public String getActionURI() {
        return this.actionURI;
    }

    @Override
    public int getSubmitMethod() {
        return this.submitMethod;
    }

    @Override
    public Iterator getElementIterator() {
        return new FormItemIterator(this.elementList);
    }

    protected static class FormItemIterator
    implements Iterator {
        protected ArrayList elementList;
        protected int currentIndex = 0;

        public FormItemIterator(ArrayList elementList) {
            this.elementList = elementList;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentIndex == this.elementList.size()) {
                    return false;
                }
                if (((FormItem)this.elementList.get(this.currentIndex)).getEnabled()) break;
                ++this.currentIndex;
            }
            return true;
        }

        public Object next() {
            while (true) {
                if (this.currentIndex == this.elementList.size()) {
                    throw new NoSuchElementException("No such element");
                }
                if (((FormItem)this.elementList.get(this.currentIndex)).getEnabled()) break;
                ++this.currentIndex;
            }
            return this.elementList.get(this.currentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported operation");
        }
    }
}

