/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.remote.ExecuteMethod;

public class RemoteLocalStorage
implements LocalStorage {
    private final ExecuteMethod executeMethod;

    public RemoteLocalStorage(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    public String getItem(String key) {
        ImmutableMap args = ImmutableMap.of((Object)"key", (Object)key);
        return (String)this.executeMethod.execute("getLocalStorageItem", (Map<String, ?>)args);
    }

    public Set<String> keySet() {
        Collection result = (Collection)this.executeMethod.execute("getLocalStorageKeys", null);
        return new HashSet<String>(result);
    }

    public void setItem(String key, String value) {
        ImmutableMap args = ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value);
        this.executeMethod.execute("setLocalStorageItem", (Map<String, ?>)args);
    }

    public String removeItem(String key) {
        String value = this.getItem(key);
        ImmutableMap args = ImmutableMap.of((Object)"key", (Object)key);
        this.executeMethod.execute("removeLocalStorageItem", (Map<String, ?>)args);
        return value;
    }

    public void clear() {
        this.executeMethod.execute("clearLocalStorage", null);
    }

    public int size() {
        Object response = this.executeMethod.execute("getLocalStorageSize", null);
        return Integer.parseInt(response.toString());
    }
}

