/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HTMLTester {
    protected File currentTestFile = null;
    protected OutputStream currentOutputStream = null;
    protected BufferedWriter currentWriter = null;
    protected int variableCounter;
    protected int currentIndentLevel;
    protected String virtualBrowserVarName;

    @Before
    public void setup() throws Exception {
        this.copyResource("VirtualBrowser.py");
        this.copyResource("Javascript.py");
        new File("test.py").delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResource(String resName) throws Exception {
        try (FileOutputStream os = new FileOutputStream(new File(resName));
             InputStream is = this.getClass().getResourceAsStream(resName);){
            String line;
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
    }

    @After
    public void teardown() throws Exception {
        this.closeAll();
        new File("Javascript.py").delete();
        new File("VirtualBrowser.py").delete();
    }

    @Test
    public void TesterTest() throws Exception {
        this.newTest(Locale.US);
        this.executeTest();
    }

    protected void closeAll() throws Exception {
        if (this.currentWriter != null) {
            this.currentWriter.flush();
            this.currentWriter = null;
        }
        if (this.currentOutputStream != null) {
            this.currentOutputStream.close();
            this.currentOutputStream = null;
        }
    }

    public void newTest(Locale desiredLocale) throws Exception {
        this.currentTestFile = new File("test.py");
        this.currentOutputStream = new FileOutputStream(this.currentTestFile);
        this.currentWriter = new BufferedWriter(new OutputStreamWriter(this.currentOutputStream, "ASCII"));
        this.variableCounter = 0;
        this.currentIndentLevel = 0;
        this.virtualBrowserVarName = this.getNextVariableName();
        this.emitLine("import time");
        this.emitLine("import sys");
        this.emitLine("sys.path.append(\".\")");
        this.emitLine("import VirtualBrowser");
        this.emitLine("if __name__ == '__main__':");
        ++this.currentIndentLevel;
        this.emitLine("print 'Starting test'");
        this.emitLine(this.virtualBrowserVarName + " = VirtualBrowser.VirtualBrowser(" + this.quotePythonString(desiredLocale.toString().replace("_", "-")) + ")");
    }

    public void executeTest() throws Exception {
        this.emitLine("print 'Test complete'");
        this.closeAll();
        Process p = Runtime.getRuntime().exec(new String[]{"python", "test.py"});
        StreamConnector mStdOut = new StreamConnector(p.getErrorStream(), "Stderr: ", System.err);
        StreamConnector mErrOut = new StreamConnector(p.getInputStream(), "Stdout: ", System.out);
        mStdOut.start();
        mErrOut.start();
        int exitCode = p.waitFor();
        mStdOut.abort();
        mErrOut.abort();
        mStdOut.join();
        mErrOut.join();
        if (exitCode != 0) {
            throw new Exception("UI test failed; error code: " + exitCode);
        }
        if (this.currentTestFile != null) {
            this.currentTestFile.delete();
            this.currentTestFile = null;
        }
    }

    public StringDescription createStringDescription(String value) throws Exception {
        String variableName = this.getNextVariableName();
        if (value != null) {
            this.emitLine(variableName + " = " + this.quotePythonString(value));
        } else {
            this.emitLine(variableName + " = None");
        }
        return new StringDescription(variableName);
    }

    public StringDescription createStringDescription(StringDescription[] values) throws Exception {
        String variableName = this.getNextVariableName();
        if (values.length == 0) {
            this.emitLine(variableName + " = " + this.quotePythonString(""));
        } else {
            StringBuilder sb = new StringBuilder(variableName);
            sb.append(" = ");
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(" + ");
                }
                sb.append(values[i].getVarName());
            }
            this.emitLine(sb.toString());
        }
        return new StringDescription(variableName);
    }

    public void printValue(StringDescription value) throws Exception {
        this.emitLine("print >> sys.stderr, " + value.getVarName());
    }

    public Loop beginLoop(int maxSeconds) throws Exception {
        String variableName = this.getNextVariableName();
        this.emitLine(variableName + " = time.time() + " + maxSeconds);
        this.emitLine("while True:");
        ++this.currentIndentLevel;
        return new Loop(variableName);
    }

    public Window openMainWindow(String url) throws Exception {
        this.emitLine(this.virtualBrowserVarName + ".load_main_window(" + this.quotePythonString(url) + ")");
        return this.findWindow(null);
    }

    public Window findWindow(StringDescription windowName) throws Exception {
        String windowVar = this.getNextVariableName();
        if (windowName != null) {
            this.emitLine(windowVar + " = " + this.virtualBrowserVarName + ".find_window(" + windowName.getVarName() + ")");
        } else {
            this.emitLine(windowVar + " = " + this.virtualBrowserVarName + ".find_window(" + this.quotePythonString("") + ")");
        }
        return new Window(windowVar);
    }

    protected String getNextVariableName() {
        String rval = "var" + this.variableCounter;
        ++this.variableCounter;
        return rval;
    }

    protected String quotePythonString(String value) {
        StringBuilder sb = new StringBuilder("\"");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append("\\").append(c);
                continue;
            }
            sb.append(c);
        }
        sb.append("\"");
        return sb.toString();
    }

    protected void emitLine(String line) throws IOException {
        StringBuilder fullLine = new StringBuilder();
        for (int i = 0; i < this.currentIndentLevel; ++i) {
            fullLine.append("    ");
        }
        fullLine.append(line);
        this.currentWriter.write(fullLine.toString());
        this.currentWriter.newLine();
    }

    protected static class StreamConnector
    extends Thread {
        protected InputStream inputStream;
        protected OutputStream outputStream;
        protected String prefix;
        protected boolean abortSignal;

        public StreamConnector(InputStream inputStream, String prefix, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.prefix = prefix;
            this.outputStream = outputStream;
            this.abortSignal = false;
        }

        public void abort() {
            this.abortSignal = true;
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[63356];
                while (true) {
                    int amt;
                    if ((amt = this.inputStream.read(buffer)) == -1) {
                        if (!this.abortSignal) {
                            Thread.yield();
                            continue;
                        }
                        break;
                    }
                    this.outputStream.write(buffer, 0, amt);
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public class StringDescription {
        protected String variableName;

        public StringDescription(String variableName) {
            this.variableName = variableName;
        }

        public String getVarName() {
            return this.variableName;
        }
    }

    public class Button {
        protected String buttonVarName;

        public Button(String buttonVarName) {
            this.buttonVarName = buttonVarName;
        }

        public void click() throws Exception {
            HTMLTester.this.emitLine(this.buttonVarName + ".click()");
        }
    }

    public class Textarea {
        protected String textAreaVarName;

        public Textarea(String textAreaVarName) {
            this.textAreaVarName = textAreaVarName;
        }

        public void setValue(StringDescription textValue) throws Exception {
            HTMLTester.this.emitLine(this.textAreaVarName + ".set_value(" + textValue.getVarName() + ")");
        }
    }

    public class Selectbox {
        protected String selectBoxVarName;

        public Selectbox(String selectBoxVarName) {
            this.selectBoxVarName = selectBoxVarName;
        }

        public void selectValue(StringDescription selectedValue) throws Exception {
            HTMLTester.this.emitLine(this.selectBoxVarName + ".select_value(" + selectedValue.getVarName() + ")");
        }

        public void selectValueRegexp(StringDescription selectedValueRegexp) throws Exception {
            HTMLTester.this.emitLine(this.selectBoxVarName + ".select_value_regexp(" + selectedValueRegexp.getVarName() + ")");
        }

        public void multiSelectValue(StringDescription selectedValue) throws Exception {
            HTMLTester.this.emitLine(this.selectBoxVarName + ".multi_select_value(" + selectedValue.getVarName() + ")");
        }
    }

    public class Radiobutton {
        protected String radioButtonVarName;

        public Radiobutton(String radioButtonVarName) {
            this.radioButtonVarName = radioButtonVarName;
        }

        public void select() throws Exception {
            HTMLTester.this.emitLine(this.radioButtonVarName + ".select()");
        }
    }

    public class Checkbox {
        protected String checkBoxVarName;

        public Checkbox(String checkBoxVarName) {
            this.checkBoxVarName = checkBoxVarName;
        }

        public void select() throws Exception {
            HTMLTester.this.emitLine(this.checkBoxVarName + ".select()");
        }

        public void deselect() throws Exception {
            HTMLTester.this.emitLine(this.checkBoxVarName + ".deselect()");
        }
    }

    public class FileBrowser {
        protected String fileBrowserVarName;

        public FileBrowser(String fileBrowserVarName) {
            this.fileBrowserVarName = fileBrowserVarName;
        }

        public void setFile(StringDescription fileName, StringDescription contentType) throws Exception {
            HTMLTester.this.emitLine(this.fileBrowserVarName + ".set_file(" + fileName.getVarName() + "," + contentType.getVarName() + ")");
        }
    }

    public class Form {
        protected String formVarName;

        public Form(String formVarName) {
            this.formVarName = formVarName;
        }

        public FileBrowser findFileBrowser(StringDescription dataName) throws Exception {
            String fileBrowserVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(fileBrowserVarName + " = " + this.formVarName + ".find_filebrowser(" + dataName.getVarName() + ")");
            return new FileBrowser(fileBrowserVarName);
        }

        public Checkbox findCheckbox(StringDescription dataName, StringDescription value) throws Exception {
            String checkboxVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(checkboxVarName + " = " + this.formVarName + ".find_checkbox(" + dataName.getVarName() + "," + value.getVarName() + ")");
            return new Checkbox(checkboxVarName);
        }

        public Radiobutton findRadiobutton(StringDescription dataName, StringDescription value) throws Exception {
            String radiobuttonVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(radiobuttonVarName + " = " + this.formVarName + ".find_radiobutton(" + dataName.getVarName() + "," + value.getVarName() + ")");
            return new Radiobutton(radiobuttonVarName);
        }

        public Selectbox findSelectbox(StringDescription dataName) throws Exception {
            String selectboxVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(selectboxVarName + " = " + this.formVarName + ".find_selectbox(" + dataName.getVarName() + ")");
            return new Selectbox(selectboxVarName);
        }

        public Textarea findTextarea(StringDescription dataName) throws Exception {
            String textareaVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(textareaVarName + " = " + this.formVarName + ".find_textarea(" + dataName.getVarName() + ")");
            return new Textarea(textareaVarName);
        }
    }

    public class Link {
        protected String linkVarName;

        public Link(String linkVarName) {
            this.linkVarName = linkVarName;
        }

        public void click() throws Exception {
            HTMLTester.this.emitLine(this.linkVarName + ".click()");
        }
    }

    public class Loop {
        protected String loopVarName;

        public Loop(String loopVarName) {
            this.loopVarName = loopVarName;
        }

        public void breakWhenTrue(StringDescription condition) throws Exception {
            HTMLTester.this.emitLine("if " + condition.getVarName() + ":");
            ++HTMLTester.this.currentIndentLevel;
            HTMLTester.this.emitLine("break");
            --HTMLTester.this.currentIndentLevel;
        }

        public void endLoop() throws Exception {
            HTMLTester.this.emitLine("time.sleep(1)");
            HTMLTester.this.emitLine("if time.time() >= " + this.loopVarName + ":");
            ++HTMLTester.this.currentIndentLevel;
            HTMLTester.this.emitLine("raise Exception('Loop timed out')");
            --HTMLTester.this.currentIndentLevel;
            --HTMLTester.this.currentIndentLevel;
        }
    }

    public class Window {
        protected String windowVar;

        public Window(String windowVar) {
            this.windowVar = windowVar;
        }

        public StringDescription isPresent(StringDescription regularExpression) throws Exception {
            String varName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(varName + " = " + this.windowVar + ".is_present(" + regularExpression.getVarName() + ")");
            return new StringDescription(varName);
        }

        public StringDescription isNotPresent(StringDescription regularExpression) throws Exception {
            String varName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(varName + " = not " + this.windowVar + ".is_present(" + regularExpression.getVarName() + ")");
            return new StringDescription(varName);
        }

        public StringDescription findMatch(StringDescription regularExpression, int group) throws Exception {
            String varName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(varName + " = " + this.windowVar + ".find_match(" + regularExpression.getVarName() + ",group=" + group + ")");
            return new StringDescription(varName);
        }

        public StringDescription findMatchNoNewlines(StringDescription regularExpression, int group) throws Exception {
            String varName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(varName + " = " + this.windowVar + ".find_match_no_newlines(" + regularExpression.getVarName() + ",group=" + group + ")");
            return new StringDescription(varName);
        }

        public void checkMatch(StringDescription regularExpression) throws Exception {
            HTMLTester.this.emitLine(this.windowVar + ".find_match(" + regularExpression.getVarName() + ")");
        }

        public void checkNoMatch(StringDescription regularExpression) throws Exception {
            HTMLTester.this.emitLine(this.windowVar + ".check_no_match(" + regularExpression.getVarName() + ")");
        }

        public Link findLink(StringDescription altText) throws Exception {
            String linkVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(linkVarName + " = " + this.windowVar + ".find_link(" + altText.getVarName() + ")");
            return new Link(linkVarName);
        }

        public Form findForm(StringDescription formName) throws Exception {
            String formVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(formVarName + " = " + this.windowVar + ".find_form(" + formName.getVarName() + ")");
            return new Form(formVarName);
        }

        public Button findButton(StringDescription altText) throws Exception {
            String buttonVarName = HTMLTester.this.getNextVariableName();
            HTMLTester.this.emitLine(buttonVarName + " = " + this.windowVar + ".find_button(" + altText.getVarName() + ")");
            return new Button(buttonVarName);
        }

        public void closeWindow() throws Exception {
            HTMLTester.this.emitLine(this.windowVar + ".close_window()");
        }
    }
}

