/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.filenet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;

public class DocClassSpec {
    public static final String _rcsid = "@(#)$Id: DocClassSpec.java 988245 2010-08-23 18:39:35Z kwright $";
    protected boolean allMetadata = false;
    protected HashMap metadataFields = new HashMap();
    protected ArrayList matchItems = new ArrayList();

    public DocClassSpec() {
    }

    public DocClassSpec(SpecificationNode sn) {
        SpecificationNode node;
        int j;
        String allmetadata = sn.getAttributeValue("allmetadata");
        if (allmetadata == null || allmetadata.length() == 0) {
            allmetadata = "false";
        }
        if (allmetadata.equals("false")) {
            j = 0;
            while (j < sn.getChildCount()) {
                if (!(node = sn.getChild(j++)).getType().equals("metafield")) continue;
                String fieldName = node.getAttributeValue("value");
                this.metadataFields.put(fieldName, fieldName);
            }
        } else {
            this.allMetadata = true;
        }
        j = 0;
        while (j < sn.getChildCount()) {
            if (!(node = sn.getChild(j++)).getType().equals("match")) continue;
            String matchTypeString = node.getAttributeValue("matchtype");
            String matchField = node.getAttributeValue("fieldname");
            String matchValue = node.getAttributeValue("value");
            this.appendMatch(matchTypeString, matchField, matchValue);
        }
    }

    public void setAllMetadata(boolean value) {
        this.allMetadata = value;
    }

    public void setMetadataField(String fieldName) {
        this.metadataFields.put(fieldName, fieldName);
        this.allMetadata = false;
    }

    public int appendMatch(String matchType, String matchField, String matchValue) {
        int rval = this.matchItems.size();
        this.matchItems.add(new MatchItem(matchType, matchField, matchValue));
        return rval;
    }

    public boolean getAllMetadata() {
        return this.allMetadata;
    }

    public String[] getMetadataFields() {
        String[] rval = new String[this.metadataFields.size()];
        Iterator iter = this.metadataFields.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    public boolean checkMetadataIncluded(String fieldName) {
        if (this.allMetadata) {
            return true;
        }
        return this.metadataFields.get(fieldName) != null;
    }

    public int getMatchCount() {
        return this.matchItems.size();
    }

    public String getMatchType(int matchIndex) {
        MatchItem mi = (MatchItem)this.matchItems.get(matchIndex);
        return mi.getMatchType();
    }

    public String getMatchField(int matchIndex) {
        MatchItem mi = (MatchItem)this.matchItems.get(matchIndex);
        return mi.getMatchField();
    }

    public String getMatchValue(int matchIndex) {
        MatchItem mi = (MatchItem)this.matchItems.get(matchIndex);
        return mi.getMatchValue();
    }

    protected static class MatchItem {
        String matchType;
        String matchField;
        String matchValue;

        public MatchItem(String matchType, String matchField, String matchValue) {
            this.matchType = matchType;
            this.matchField = matchField;
            this.matchValue = matchValue;
        }

        public String getMatchType() {
            return this.matchType;
        }

        public String getMatchField() {
            return this.matchField;
        }

        public String getMatchValue() {
            return this.matchValue;
        }
    }
}

