/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class IfCommand
implements Command {
    @Override
    public boolean parseAndExecute(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        boolean rval = false;
        VariableReference ifCondition = sp.evaluateExpression(currentStream);
        if (ifCondition == null) {
            ScriptParser.syntaxError(currentStream, "Missing if expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("then")) {
            ScriptParser.syntaxError(currentStream, "Missing 'then' in if statement");
        }
        currentStream.skip();
        if (ScriptParser.resolveMustExist(currentStream, ifCondition).getBooleanValue()) {
            rval = sp.parseStatements(currentStream);
            t = currentStream.peek();
            if (t != null && t.getToken() != null && t.getToken().equals("else")) {
                currentStream.skip();
                sp.skipStatements(currentStream);
            }
        } else {
            sp.skipStatements(currentStream);
            t = currentStream.peek();
            if (t != null && t.getToken() != null && t.getToken().equals("else")) {
                currentStream.skip();
                rval = sp.parseStatements(currentStream);
            }
        }
        return rval;
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing if expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("then")) {
            ScriptParser.syntaxError(currentStream, "Missing 'then' in if statement");
        }
        currentStream.skip();
        sp.skipStatements(currentStream);
        t = currentStream.peek();
        if (t != null && t.getToken() != null && t.getToken().equals("else")) {
            currentStream.skip();
            sp.skipStatements(currentStream);
        }
    }
}

