/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.alfrescowebscript;

import com.github.maoo.indexer.client.AlfrescoClient;
import com.github.maoo.indexer.client.AlfrescoDownException;
import com.github.maoo.indexer.client.AlfrescoUser;
import com.github.maoo.indexer.client.WebScriptsAlfrescoClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.alfrescowebscript.ConfigurationHandler;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AlfrescoAuthorityConnector
extends BaseAuthorityConnector {
    private AlfrescoClient alfrescoClient;

    public void setClient(AlfrescoClient client) {
        this.alfrescoClient = client;
    }

    public void connect(ConfigParams config) {
        super.connect(config);
        String protocol = AlfrescoAuthorityConnector.getConfig(config, "protocol", "http");
        String hostname = AlfrescoAuthorityConnector.getConfig(config, "hostname", "localhost");
        String port = AlfrescoAuthorityConnector.getConfig(config, "port", "8080");
        String endpoint = AlfrescoAuthorityConnector.getConfig(config, "endpoint", "/alfresco/service");
        String username = AlfrescoAuthorityConnector.getConfig(config, "username", null);
        String password = AlfrescoAuthorityConnector.getObfuscatedConfig(config, "password", null);
        this.alfrescoClient = new WebScriptsAlfrescoClient(protocol, hostname + ":" + port, endpoint, null, null, username, password);
    }

    private static String getConfig(ConfigParams config, String parameter, String defaultValue) {
        String protocol = config.getParameter(parameter);
        if (protocol == null) {
            return defaultValue;
        }
        return protocol;
    }

    private static String getObfuscatedConfig(ConfigParams config, String parameter, String defaultValue) {
        String protocol = config.getObfuscatedParameter(parameter);
        if (protocol == null) {
            return defaultValue;
        }
        return protocol;
    }

    public String check() throws ManifoldCFException {
        try {
            this.alfrescoClient.fetchUserAuthorities("admin");
            return super.check();
        }
        catch (AlfrescoDownException e) {
            if (Logging.authorityConnectors != null) {
                Logging.authorityConnectors.warn((Object)e.getMessage(), (Throwable)e);
            }
            return "Connection failed: " + e.getMessage();
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.alfrescoClient = null;
        super.disconnect();
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        try {
            AlfrescoUser permissions = this.alfrescoClient.fetchUserAuthorities(userName);
            if (permissions.getUsername() == null || permissions.getUsername().isEmpty() || permissions.getAuthorities().isEmpty()) {
                return RESPONSE_USERNOTFOUND;
            }
            ArrayList<String> rval = new ArrayList<String>(permissions.getAuthorities());
            rval.add(permissions.getUsername());
            return new AuthorizationResponse(rval.toArray(new String[rval.size()]), 0);
        }
        catch (AlfrescoDownException e) {
            return RESPONSE_UNREACHABLE;
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        ConfigurationHandler.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        ConfigurationHandler.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        return ConfigurationHandler.processConfigurationPost(threadContext, variableContext, locale, parameters);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        ConfigurationHandler.viewConfiguration(threadContext, out, locale, parameters);
    }
}

