/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.extractor;

import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.credentials.extractor.OAuthCredentialsExtractor;
import org.pac4j.oauth.exception.OAuthCredentialsException;

public class OAuth10CredentialsExtractor
extends OAuthCredentialsExtractor<OAuth10Credentials, OAuth10Configuration> {
    public OAuth10CredentialsExtractor(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected Optional<OAuth10Credentials> getOAuthCredentials(WebContext context) {
        Optional tokenParameter = context.getRequestParameter("oauth_token");
        Optional verifierParameter = context.getRequestParameter("oauth_verifier");
        if (tokenParameter.isPresent() && verifierParameter.isPresent()) {
            OAuth1RequestToken tokenSession = context.getSessionStore().get(context, ((OAuth10Configuration)this.configuration).getRequestTokenSessionAttributeName(this.client.getName())).orElse(null);
            this.logger.debug("tokenRequest: {}", (Object)tokenSession);
            String token = OAuthEncoder.decode((String)((String)tokenParameter.get()));
            String verifier = OAuthEncoder.decode((String)((String)verifierParameter.get()));
            this.logger.debug("token: {} / verifier: {}", (Object)token, (Object)verifier);
            return Optional.of(new OAuth10Credentials(tokenSession, token, verifier));
        }
        String message = "No credential found";
        throw new OAuthCredentialsException("No credential found");
    }
}

