/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments to update certificates from the Auto-TLS truststore")
public class ApiUpdateGlobalTruststoreArguments {
    @SerializedName(value="newCertLocation")
    private String newCertLocation = null;
    @SerializedName(value="newCertContent")
    private String newCertContent = null;

    public ApiUpdateGlobalTruststoreArguments newCertLocation(String newCertLocation) {
        this.newCertLocation = newCertLocation;
        return this;
    }

    @Schema(description="The location of the new certificate on the disk to be added to the Auto-TLS truststore. PEM format is required. Specify either this or a NewCertContent.")
    public String getNewCertLocation() {
        return this.newCertLocation;
    }

    public void setNewCertLocation(String newCertLocation) {
        this.newCertLocation = newCertLocation;
    }

    public ApiUpdateGlobalTruststoreArguments newCertContent(String newCertContent) {
        this.newCertContent = newCertContent;
        return this;
    }

    @Schema(description="The content of the new certificate to be added to the Auto-TLS truststore. Specify either this or a NewCertLocation. <br> The certificate, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN CERTIFICATE-----\\n[base-64 encoded key]\\n-----END CERTIFICATE----- <br>")
    public String getNewCertContent() {
        return this.newCertContent;
    }

    public void setNewCertContent(String newCertContent) {
        this.newCertContent = newCertContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUpdateGlobalTruststoreArguments apiUpdateGlobalTruststoreArguments = (ApiUpdateGlobalTruststoreArguments)o;
        return Objects.equals(this.newCertLocation, apiUpdateGlobalTruststoreArguments.newCertLocation) && Objects.equals(this.newCertContent, apiUpdateGlobalTruststoreArguments.newCertContent);
    }

    public int hashCode() {
        return Objects.hash(this.newCertLocation, this.newCertContent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUpdateGlobalTruststoreArguments {\n");
        sb.append("    newCertLocation: ").append(this.toIndentedString(this.newCertLocation)).append("\n");
        sb.append("    newCertContent: ").append(this.toIndentedString(this.newCertContent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

