/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Stax2SAXAdapter {
    private XMLStreamReader staxReader;
    private boolean readDocument = false;

    public Stax2SAXAdapter(XMLStreamReader stax, boolean readDocument) {
        this.staxReader = stax;
        this.readDocument = readDocument;
    }

    public void parse(ContentHandler handler) throws XMLStreamException, SAXException {
        Stack<String> stack = new Stack<String>();
        boolean done = false;
        while (!done) {
            int event = this.staxReader.getEventType();
            switch (event) {
                case 7: {
                    if (!this.readDocument) break;
                    this.processDocument(handler);
                    break;
                }
                case 8: {
                    if (this.readDocument) {
                        handler.endDocument();
                    }
                    done = true;
                    break;
                }
                case 1: {
                    stack.push(this.staxReader.getLocalName());
                    this.processStartElement(handler);
                    break;
                }
                case 2: {
                    this.processEndElement(handler);
                    stack.pop();
                    if (!stack.isEmpty() || this.readDocument) break;
                    done = true;
                    break;
                }
                case 4: {
                    handler.characters(this.staxReader.getTextCharacters(), this.staxReader.getTextStart(), this.staxReader.getTextLength());
                    break;
                }
                case 12: {
                    break;
                }
                case 10: {
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    break;
                }
                case 15: {
                    break;
                }
                case 9: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 3: {
                    handler.processingInstruction(this.staxReader.getPIData(), this.staxReader.getPITarget());
                    break;
                }
            }
            this.staxReader.next();
        }
        this.staxReader.close();
    }

    private void processDocument(ContentHandler handler) throws SAXException {
        Location loc = this.staxReader.getLocation();
        handler.setDocumentLocator(new SAXLocator(loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber()));
        handler.startDocument();
    }

    private void processStartElement(ContentHandler handler) throws SAXException {
        int namespaceCount = this.staxReader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String p = this.staxReader.getNamespacePrefix(i);
            if (p == null) {
                p = "";
            }
            String u = this.staxReader.getNamespaceURI(i);
            handler.startPrefixMapping(p, u);
        }
        QName qname = this.staxReader.getName();
        String namespaceURI = qname.getNamespaceURI();
        String prefix = qname.getPrefix();
        String localName = qname.getLocalPart();
        int attCount = this.staxReader.getAttributeCount();
        AttributesImpl atts = new AttributesImpl();
        for (int i = 0; i < attCount; ++i) {
            String p = this.staxReader.getAttributePrefix(i);
            if (p == null) {
                p = "";
            }
            String l = this.staxReader.getAttributeLocalName(i);
            String u = this.staxReader.getAttributeNamespace(i);
            String type = this.staxReader.getAttributeType(i);
            String value = this.staxReader.getAttributeValue(i);
            atts.addAttribute(u, l, this.getPrefixName(p, l), type, value);
        }
        handler.startElement(namespaceURI, localName, this.getPrefixName(prefix, localName), atts);
    }

    private void processEndElement(ContentHandler handler) throws SAXException {
        QName qname = this.staxReader.getName();
        String namespaceURI = qname.getNamespaceURI();
        String prefix = qname.getPrefix();
        String localName = qname.getLocalPart();
        handler.endElement(namespaceURI, localName, this.getPrefixName(prefix, localName));
        int namespaceCount = this.staxReader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String p = this.staxReader.getNamespacePrefix(i);
            if (p == null) {
                p = "";
            }
            handler.endPrefixMapping(p);
        }
    }

    private String getPrefixName(String prefix, String local) {
        if (prefix == null || prefix.length() == 0) {
            return local;
        }
        return prefix + ":" + local;
    }

    private static class SAXLocator
    implements Locator {
        private String publicId;
        private String systemId;
        private int lineNumber;
        private int columnNumber;

        public SAXLocator(String publicId, String systemId, int lineNumber, int columnNumber) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }
    }
}

