/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.TopologyBuilder;

public class BeanPropertyTopologyBuilder
implements TopologyBuilder {
    private String name;
    private String defaultService;
    private boolean isGenerated;
    private long redeployTime;
    private List<Provider> providers = new ArrayList<Provider>();
    private List<Service> services = new ArrayList<Service>();
    private List<Application> applications = new ArrayList<Application>();

    public BeanPropertyTopologyBuilder name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public BeanPropertyTopologyBuilder generated(String isGenerated) {
        this.isGenerated = Boolean.valueOf(isGenerated);
        return this;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public BeanPropertyTopologyBuilder redeployTime(String redeployTime) {
        this.redeployTime = Long.parseLong(redeployTime);
        return this;
    }

    public long getRedeployTime() {
        return this.redeployTime;
    }

    public BeanPropertyTopologyBuilder defaultService(String defaultService) {
        this.defaultService = defaultService;
        return this;
    }

    public String defaultService() {
        return this.defaultService;
    }

    public BeanPropertyTopologyBuilder addProvider(Provider provider) {
        this.providers.add(provider);
        return this;
    }

    public List<Provider> providers() {
        return this.providers;
    }

    public BeanPropertyTopologyBuilder addService(Service service) {
        this.services.add(service);
        return this;
    }

    public List<Service> services() {
        return this.services;
    }

    public BeanPropertyTopologyBuilder addApplication(Application application) {
        this.applications.add(application);
        return this;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public Topology build() {
        Topology topology = new Topology();
        topology.setName(this.name);
        topology.setDefaultServicePath(this.defaultService);
        topology.setGenerated(this.isGenerated);
        topology.setRedeployTime(this.redeployTime);
        for (Provider provider : this.providers) {
            topology.addProvider(provider);
        }
        for (Service service : this.services) {
            topology.addService(service);
        }
        for (Application application : this.applications) {
            topology.addApplication(application);
        }
        return topology;
    }
}

