/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.store.ConfigStore;

public class MemoryStore
extends ConfigStore {
    public static final MemoryStore DEFAULT = MemoryStore.create().build();
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();

    public static Builder create() {
        return new Builder();
    }

    public MemoryStore(Builder builder) {
        super(builder);
    }

    @Override
    public void close() throws IOException {
    }

    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public synchronized boolean exists(String name) {
        return this.cache.containsKey(name);
    }

    @Override
    public synchronized String read(String name) {
        return Utils.emptyIfNull((Object)this.cache.get(name));
    }

    @Override
    public synchronized MemoryStore update(String name, String newContents) {
        if (newContents == null) {
            this.cache.remove(name);
        } else {
            this.cache.put(name, newContents);
        }
        super.update(name, newContents);
        return this;
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) {
        if (Utils.eq((Object)expectedContents, (Object)newContents)) {
            return null;
        }
        String currentContents = this.read(name);
        if (Utils.nn((Object)expectedContents) && Utils.neq((Object)currentContents, (Object)expectedContents)) {
            return currentContents;
        }
        this.update(name, newContents);
        return null;
    }

    public static class Builder
    extends ConfigStore.Builder {
        protected Builder() {
        }

        protected Builder(Builder copyFrom) {
            super((ConfigStore.Builder)((Object)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)((Object)copyFrom))));
        }

        protected Builder(MemoryStore copyFrom) {
            super((ConfigStore)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.type(copyFrom.getClass());
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public MemoryStore build() {
            return (MemoryStore)this.build(MemoryStore.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }
    }
}

