/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.console;

import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.juneau.collections.Args;
import org.apache.juneau.config.Config;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.console.ConsoleCommand;

public class ConfigCommand
extends ConsoleCommand {
    private final Messages mb = Messages.of(ConfigCommand.class, "Messages");

    @Override
    public String getName() {
        return "config";
    }

    @Override
    public String getSynopsis() {
        return "config [get|set]";
    }

    @Override
    public String getInfo() {
        return this.mb.getString("info");
    }

    @Override
    public String getDescription() {
        return this.mb.getString("description");
    }

    @Override
    public boolean execute(Scanner in, PrintWriter out, Args args) {
        Config conf = Microservice.getInstance().getConfig();
        if (args.size() > 2) {
            String option = args.getArg(1);
            String key = args.getArg(2);
            if (option.equals("get")) {
                if (args.size() == 3) {
                    String val = conf.get(key).orElse(null);
                    if (val != null) {
                        out.println(val);
                    } else {
                        out.println(this.mb.getString("KeyNotFound", key));
                    }
                } else {
                    out.println(this.mb.getString("TooManyArguments"));
                }
            } else if (option.equals("set")) {
                if (args.size() == 4) {
                    conf.set(key, args.getArg(3));
                    out.println(this.mb.getString("ConfigSet"));
                } else if (args.size() < 4) {
                    out.println(this.mb.getString("InvalidArguments"));
                } else {
                    out.println(this.mb.getString("TooManyArguments"));
                }
            } else if (option.equals("remove")) {
                if (args.size() == 3) {
                    if (conf.get(key).isPresent()) {
                        conf.remove(key);
                        out.println(this.mb.getString("ConfigRemove", key));
                    } else {
                        out.println(this.mb.getString("KeyNotFound", key));
                    }
                } else {
                    out.println(this.mb.getString("TooManyArguments"));
                }
            } else {
                out.println(this.mb.getString("InvalidArguments"));
            }
        } else {
            out.println(this.mb.getString("InvalidArguments"));
        }
        return false;
    }
}

