/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.dto.html5.Div;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.dto.html5.HtmlElement;
import org.apache.juneau.dto.html5.Select;
import org.apache.juneau.dto.html5.Table;
import org.apache.juneau.dto.html5.Td;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.swap.ObjectSwap;

public class SwaggerUI
extends ObjectSwap<Swagger, Div> {
    static final FileFinder RESOURCES = (FileFinder)FileFinder.create(BeanStore.INSTANCE).cp(SwaggerUI.class, null, true).dir(",").caching(Boolean.getBoolean("RestContext.disableClasspathResourceCaching.b") ? -1L : 1000000L).build();
    private static final Set<String> STANDARD_METHODS = CollectionUtils.set("get", "put", "post", "delete", "options");

    @Override
    public MediaType[] forMediaTypes() {
        return new MediaType[]{MediaType.HTML};
    }

    @Override
    public Div swap(BeanSession beanSession, Swagger swagger) throws Exception {
        Session s = new Session(beanSession, swagger);
        String css = RESOURCES.getString("files/htdocs/styles/SwaggerUI.css", null).orElse(null);
        if (css == null) {
            css = RESOURCES.getString("SwaggerUI.css", null).orElse(null);
        }
        Div outer = HtmlBuilder.div(HtmlBuilder.style((Object)css), HtmlBuilder.script("text/javascript", RESOURCES.getString("SwaggerUI.js", null).orElse(null)), this.header(s))._class("swagger-ui");
        outer.child(HtmlBuilder.div()._class("tag-block tag-block-open").children(this.tagBlockContents(s, null)));
        if (s.swagger.getTags() != null) {
            s.swagger.getTags().forEach(x -> {
                Div tagBlock = HtmlBuilder.div()._class("tag-block tag-block-open").children(this.tagBlockSummary((Tag)x), this.tagBlockContents(s, (Tag)x));
                outer.child(tagBlock);
            });
        }
        if (s.swagger.getDefinitions() != null) {
            Div modelBlock = HtmlBuilder.div()._class("tag-block").children(this.modelsBlockSummary(), this.modelsBlockContents(s));
            outer.child(modelBlock);
        }
        return outer;
    }

    private Table header(Session s) {
        Table table = HtmlBuilder.table()._class("header");
        Info info = s.swagger.getInfo();
        if (info != null) {
            ExternalDocumentation ed;
            License l;
            Contact c;
            if (info.getDescription() != null) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Description:"), HtmlBuilder.td(SwaggerUI.toBRL(info.getDescription()))));
            }
            if (info.getVersion() != null) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Version:"), HtmlBuilder.td(info.getVersion())));
            }
            if ((c = info.getContact()) != null) {
                Table t2 = HtmlBuilder.table();
                if (c.getName() != null) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Name:"), HtmlBuilder.td(c.getName())));
                }
                if (c.getUrl() != null) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("URL:"), HtmlBuilder.td(HtmlBuilder.a(c.getUrl(), c.getUrl()))));
                }
                if (c.getEmail() != null) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Email:"), HtmlBuilder.td(HtmlBuilder.a("mailto:" + c.getEmail(), c.getEmail()))));
                }
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Contact:"), HtmlBuilder.td(t2)));
            }
            if ((l = info.getLicense()) != null) {
                String child = l.getUrl() != null ? HtmlBuilder.a(l.getUrl(), l.getName() != null ? l.getName() : l.getUrl()) : l.getName();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("License:"), HtmlBuilder.td(child)));
            }
            if ((ed = s.swagger.getExternalDocs()) != null) {
                String child = ed.getUrl() != null ? HtmlBuilder.a(ed.getUrl(), ed.getDescription() != null ? ed.getDescription() : ed.getUrl()) : ed.getDescription();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Docs:"), HtmlBuilder.td(child)));
            }
            if (info.getTermsOfService() != null) {
                String tos = info.getTermsOfService();
                String child = StringUtils.isUri(tos) ? HtmlBuilder.a(tos, tos) : tos;
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Terms of Service:"), HtmlBuilder.td(child)));
            }
        }
        return table;
    }

    private HtmlElement tagBlockSummary(Tag t) {
        ExternalDocumentation ed = t.getExternalDocs();
        return HtmlBuilder.div()._class("tag-block-summary").children(HtmlBuilder.span(t.getName())._class("name"), HtmlBuilder.span(SwaggerUI.toBRL(t.getDescription()))._class("description"), ed == null ? null : HtmlBuilder.span(HtmlBuilder.a(ed.getUrl(), ed.getDescription() != null ? ed.getDescription() : ed.getUrl()))._class("extdocs")).onclick("toggleTagBlock(this)");
    }

    private Div tagBlockContents(Session s, Tag t) {
        Div tagBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        s.swagger.getPaths().forEach((path, v) -> v.forEach((opName, op) -> {
            if (t == null && op.getTags() == null || t != null && op.getTags() != null && op.getTags() != null && op.getTags().contains(t.getName())) {
                tagBlockContents.child(this.opBlock(s, (String)path, (String)opName, (Operation)op));
            }
        }));
        return tagBlockContents;
    }

    private Div opBlock(Session s, String path, String opName, Operation op) {
        String opClass;
        String string = opClass = op.isDeprecated() ? "deprecated" : opName.toLowerCase();
        if (!op.isDeprecated() && !STANDARD_METHODS.contains(opClass)) {
            opClass = "other";
        }
        return HtmlBuilder.div()._class("op-block op-block-closed " + opClass).children(this.opBlockSummary(path, opName, op), HtmlBuilder.div(this.tableContainer(s, op))._class("op-block-contents"));
    }

    private HtmlElement opBlockSummary(String path, String opName, Operation op) {
        return HtmlBuilder.div()._class("op-block-summary").children(HtmlBuilder.span(opName.toUpperCase())._class("method-button"), HtmlBuilder.span(path)._class("path"), op.getSummary() != null ? HtmlBuilder.span(op.getSummary())._class("summary") : null).onclick("toggleOpBlock(this)");
    }

    private Div tableContainer(Session s, Operation op) {
        Div tableContainer = HtmlBuilder.div()._class("table-container");
        if (op.getDescription() != null) {
            tableContainer.child(HtmlBuilder.div(SwaggerUI.toBRL(op.getDescription()))._class("op-block-description"));
        }
        if (op.getParameters() != null) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Parameters")._class("title"))._class("op-block-section-header"));
            Table parameters = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name")._class("parameter-key"), HtmlBuilder.th("Description")._class("parameter-key")))._class("parameters");
            op.getParameters().forEach(x -> {
                String piName = "body".equals(x.getIn()) ? "body" : x.getName();
                boolean required = x.getRequired() == null ? false : x.getRequired();
                Td parameterKey = HtmlBuilder.td(HtmlBuilder.div(piName)._class("name" + (required ? " required" : "")), required ? HtmlBuilder.div("required")._class("requiredlabel") : null, HtmlBuilder.div(x.getType())._class("type"), HtmlBuilder.div("(" + x.getIn() + ")")._class("in"))._class("parameter-key");
                Td parameterValue = HtmlBuilder.td(HtmlBuilder.div(SwaggerUI.toBRL(x.getDescription()))._class("description"), this.examples(s, (ParameterInfo)x))._class("parameter-value");
                parameters.child(HtmlBuilder.tr(parameterKey, parameterValue));
            });
            tableContainer.child(parameters);
        }
        if (op.getResponses() != null) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Responses")._class("title"))._class("op-block-section-header"));
            Table responses = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Code")._class("response-key"), HtmlBuilder.th("Description")._class("response-key")))._class("responses");
            tableContainer.child(responses);
            op.getResponses().forEach((k, v) -> {
                Td code = HtmlBuilder.td(k)._class("response-key");
                Td codeValue = HtmlBuilder.td(HtmlBuilder.div(SwaggerUI.toBRL(v.getDescription()))._class("description"), this.examples(s, (ResponseInfo)v), this.headers(s, (ResponseInfo)v))._class("response-value");
                responses.child(HtmlBuilder.tr(code, codeValue));
            });
        }
        return tableContainer;
    }

    private Div headers(Session s, ResponseInfo ri) {
        if (ri.getHeaders() == null) {
            return null;
        }
        Table sectionTable = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name"), HtmlBuilder.th("Description"), HtmlBuilder.th("Schema")))._class("section-table");
        Div headers = HtmlBuilder.div(HtmlBuilder.div("Headers:")._class("section-name"), sectionTable)._class("headers");
        ri.getHeaders().forEach((k, v) -> sectionTable.child(HtmlBuilder.tr(HtmlBuilder.td(k)._class("name"), HtmlBuilder.td(SwaggerUI.toBRL(v.getDescription()))._class("description"), HtmlBuilder.td(v.asMap().keepAll("type", "format", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf")))));
        return headers;
    }

    private Div examples(Session s, ParameterInfo pi) {
        boolean isBody = "body".equals(pi.getIn());
        JsonMap m = new JsonMap();
        try {
            if (isBody) {
                SchemaInfo si = pi.getSchema();
                if (si != null) {
                    m.put("model", (Object)si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth));
                }
            } else {
                JsonMap m2 = pi.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth).asMap().keepAll("format", "pattern", "collectionFormat", "maximum", "minimum", "multipleOf", "maxLength", "minLength", "maxItems", "minItems", "allowEmptyValue", "exclusiveMaximum", "exclusiveMinimum", "uniqueItems", "items", "default", "enum");
                m.put("model", m2.isEmpty() ? HtmlBuilder.i("none") : m2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return this.examplesDiv(m);
    }

    private Div examples(Session s, ResponseInfo ri) {
        SchemaInfo si = ri.getSchema();
        JsonMap m = new JsonMap();
        try {
            Map<String, Object> examples;
            if (si != null) {
                si = si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth);
                m.put("model", (Object)si);
            }
            if ((examples = ri.getExamples()) != null) {
                examples.forEach((k, v) -> m.put((String)k, v));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return this.examplesDiv(m);
    }

    private Div examplesDiv(JsonMap m) {
        if (m.isEmpty()) {
            return null;
        }
        Select select = null;
        if (m.size() > 1) {
            select = HtmlBuilder.select().onchange("selectExample(this)")._class("example-select");
        }
        Div div = HtmlBuilder.div(select)._class("examples");
        if (select != null) {
            select.child(HtmlBuilder.option("model", "model"));
        }
        div.child(HtmlBuilder.div(m.remove("model"))._class("model active").attr("data-name", "model"));
        Select select2 = select;
        m.forEach((k, v) -> {
            if (select2 != null) {
                select2.child(HtmlBuilder.option(k, k));
            }
            div.child(HtmlBuilder.div(v.toString().replaceAll("\\n", "\n"))._class("example").attr("data-name", k));
        });
        return div;
    }

    private HtmlElement modelsBlockSummary() {
        return HtmlBuilder.div()._class("tag-block-summary").children(HtmlBuilder.span("Models")._class("name")).onclick("toggleTagBlock(this)");
    }

    private Div modelsBlockContents(Session s) {
        Div modelBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        s.swagger.getDefinitions().forEach((k, v) -> modelBlockContents.child(this.modelBlock((String)k, (JsonMap)v)));
        return modelBlockContents;
    }

    private Div modelBlock(String modelName, JsonMap model) {
        return HtmlBuilder.div()._class("op-block op-block-closed model").children(this.modelBlockSummary(modelName, model), HtmlBuilder.div(model)._class("op-block-contents"));
    }

    private HtmlElement modelBlockSummary(String modelName, JsonMap model) {
        return HtmlBuilder.div()._class("op-block-summary").children(HtmlBuilder.span(modelName)._class("method-button"), model.containsKey("description") ? HtmlBuilder.span(SwaggerUI.toBRL(model.remove("description").toString()))._class("summary") : null).onclick("toggleOpBlock(this)");
    }

    private static List<Object> toBRL(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(s);
        }
        ArrayList<Object> l = CollectionUtils.list(new Object[0]);
        String[] sa = s.split("\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                l.add(HtmlBuilder.br());
            }
            l.add(sa[i]);
        }
        return l;
    }

    private static final class Session {
        final int resolveRefsMaxDepth;
        final Swagger swagger;

        Session(BeanSession bs, Swagger swagger) {
            this.swagger = swagger.copy();
            this.resolveRefsMaxDepth = 1;
        }
    }
}

