/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.common.internal;

import java.text.MessageFormat;

public class ArgUtils {
    public static final <T> T assertArgNotNull(String name, T o) throws IllegalArgumentException {
        ArgUtils.assertArg(o != null, "Argument ''{0}'' cannot be null.", name);
        return o;
    }

    public static final void assertArg(boolean expression, String msg, Object ... args) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
    }

    public static final <E> Class<E>[] assertClassArrayArgIsType(String name, Class<E> type, Class<?>[] value) throws IllegalArgumentException {
        for (int i = 0; i < value.length; ++i) {
            if (type.isAssignableFrom(value[i])) continue;
            throw new IllegalArgumentException("Arg " + name + " did not have arg of type " + type.getName() + " at index " + i + ": " + value[i].getName());
        }
        return value;
    }
}

