/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.tags.WikiTagBase;

public class InsertPageTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LogManager.getLogger(InsertPageTag.class);
    public static final int HTML = 0;
    public static final int PLAIN = 1;
    protected String m_pageName;
    private int m_mode = 0;

    @Override
    public void initTag() {
        super.initTag();
        this.m_pageName = null;
        this.m_mode = 0;
    }

    public void setPage(String page) {
        this.m_pageName = page;
    }

    public String getPage() {
        return this.m_pageName;
    }

    public void setMode(String arg) {
        this.m_mode = "plain".equals(arg) ? 1 : 0;
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        Page insertedPage;
        Engine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null) {
            insertedPage = this.m_wikiContext.getPage();
            if (!((PageManager)engine.getManager(PageManager.class)).wikiPageExists(insertedPage)) {
                return 0;
            }
        } else {
            insertedPage = ((PageManager)engine.getManager(PageManager.class)).getPage(this.m_pageName);
        }
        if (insertedPage != null) {
            LOG.debug("Inserting page " + insertedPage);
            JspWriter out = this.pageContext.getOut();
            Page oldPage = this.m_wikiContext.setRealPage(insertedPage);
            switch (this.m_mode) {
                case 0: {
                    out.print(((RenderingManager)engine.getManager(RenderingManager.class)).getHTML(this.m_wikiContext, insertedPage));
                    break;
                }
                case 1: {
                    out.print(((PageManager)engine.getManager(PageManager.class)).getText(insertedPage));
                }
            }
            this.m_wikiContext.setRealPage(oldPage);
        }
        return 0;
    }
}

