/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.shared.common.error.StandardException;

public class StatementTablePermission
extends StatementPermission {
    UUID tableUUID;
    int privType;

    public StatementTablePermission(UUID uUID, int n) {
        this.tableUUID = uUID;
        this.privType = n;
    }

    public int getPrivType() {
        return this.privType;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            StatementTablePermission statementTablePermission = (StatementTablePermission)object;
            return this.privType == statementTablePermission.privType && this.tableUUID.equals(statementTablePermission.tableUUID);
        }
        return false;
    }

    public int hashCode() {
        return this.privType + this.tableUUID.hashCode();
    }

    @Override
    public void check(LanguageConnectionContext languageConnectionContext, boolean bl, Activation activation) throws StandardException {
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        if (!this.hasPermissionOnTable(languageConnectionContext, activation, bl, execPreparedStatement)) {
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            TableDescriptor tableDescriptor = this.getTableDescriptor(dataDictionary);
            throw StandardException.newException((String)(bl ? "42501" : "42500"), (Object[])new Object[]{languageConnectionContext.getCurrentUserId(activation), this.getPrivName(), tableDescriptor.getSchemaName(), tableDescriptor.getName()});
        }
    }

    protected TableDescriptor getTableDescriptor(DataDictionary dataDictionary) throws StandardException {
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableUUID);
        if (tableDescriptor == null) {
            throw StandardException.newException((String)"4250E", (Object[])new Object[]{"table"});
        }
        return tableDescriptor;
    }

    protected boolean hasPermissionOnTable(LanguageConnectionContext languageConnectionContext, Activation activation, boolean bl, ExecPreparedStatement execPreparedStatement) throws StandardException {
        String string;
        boolean bl2;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string2 = languageConnectionContext.getCurrentUserId(activation);
        boolean bl3 = bl2 = this.oneAuthHasPermissionOnTable(dataDictionary, "PUBLIC", bl) || this.oneAuthHasPermissionOnTable(dataDictionary, string2, bl);
        if (!bl2 && (string = languageConnectionContext.getCurrentRoleId(activation)) != null) {
            String string3 = dataDictionary.getAuthorizationDatabaseOwner();
            RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string, string2, string3);
            if (roleGrantDescriptor == null) {
                roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string, "PUBLIC", string3);
            }
            if (roleGrantDescriptor == null) {
                languageConnectionContext.setCurrentRole(activation, null);
            } else {
                String string4;
                RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string, true);
                while (!bl2 && (string4 = roleClosureIterator.next()) != null) {
                    bl2 = this.oneAuthHasPermissionOnTable(dataDictionary, string4, bl);
                }
                if (bl2) {
                    DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                    RoleGrantDescriptor roleGrantDescriptor2 = dataDictionary.getRoleDefinitionDescriptor(string);
                    ContextManager contextManager = languageConnectionContext.getContextManager();
                    dependencyManager.addDependency(execPreparedStatement, roleGrantDescriptor2, contextManager);
                    dependencyManager.addDependency(activation, roleGrantDescriptor2, contextManager);
                }
            }
        }
        return bl2;
    }

    protected boolean oneAuthHasPermissionOnTable(DataDictionary dataDictionary, String string, boolean bl) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = dataDictionary.getTablePermissions(this.tableUUID, string);
        if (tablePermsDescriptor == null) {
            return false;
        }
        String string2 = null;
        switch (this.privType) {
            case 0: 
            case 8: {
                string2 = tablePermsDescriptor.getSelectPriv();
                break;
            }
            case 1: {
                string2 = tablePermsDescriptor.getUpdatePriv();
                break;
            }
            case 2: {
                string2 = tablePermsDescriptor.getReferencesPriv();
                break;
            }
            case 3: {
                string2 = tablePermsDescriptor.getInsertPriv();
                break;
            }
            case 4: {
                string2 = tablePermsDescriptor.getDeletePriv();
                break;
            }
            case 5: {
                string2 = tablePermsDescriptor.getTriggerPriv();
            }
        }
        return "Y".equals(string2) || !bl && "y".equals(string2);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dataDictionary, string, false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, string);
        }
        return null;
    }

    public String getPrivName() {
        switch (this.privType) {
            case 0: 
            case 8: {
                return "SELECT";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "REFERENCES";
            }
            case 3: {
                return "INSERT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "TRIGGER";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementTablePermission: " + this.getPrivName() + " " + String.valueOf(this.tableUUID);
    }
}

