/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.scanning;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRatio;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.quota.search.QuotaClause;

public class ClauseConverter {
    private final UserQuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;
    private final Map<Class<? extends QuotaClause>, Function<QuotaClause, Predicate<Username>>> toPredicates;

    @Inject
    public ClauseConverter(UserQuotaRootResolver quotaRootResolver, QuotaManager quotaManager) {
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
        this.toPredicates = ImmutableMap.of(QuotaClause.And.class, this::andToPredicate, QuotaClause.LessThan.class, this::lessThanToPredicate, QuotaClause.MoreThan.class, this::moreThanToPredicate, QuotaClause.HasDomain.class, this::hasDomainToPredicate);
    }

    public Predicate<Username> andToPredicate(QuotaClause.And and) {
        return and.getClauses().stream().map(this::toPredicate).reduce((p1, p2) -> user -> p1.test(user) && p2.test(user)).orElse(user -> true);
    }

    private Predicate<Username> toPredicate(QuotaClause clause) {
        return this.toPredicates.get(clause.getClass()).apply(clause);
    }

    private Predicate<Username> moreThanToPredicate(QuotaClause clause) {
        QuotaClause.MoreThan moreThan = (QuotaClause.MoreThan)clause;
        return user -> this.retrieveUserRatio((Username)user) >= moreThan.getQuotaBoundary().getRatio();
    }

    private Predicate<Username> lessThanToPredicate(QuotaClause clause) {
        QuotaClause.LessThan lessThan = (QuotaClause.LessThan)clause;
        return user -> this.retrieveUserRatio((Username)user) <= lessThan.getQuotaBoundary().getRatio();
    }

    private Predicate<Username> hasDomainToPredicate(QuotaClause clause) {
        QuotaClause.HasDomain hasDomain = (QuotaClause.HasDomain)clause;
        return user -> user.getDomainPart().map(arg_0 -> ((Domain)hasDomain.getDomain()).equals(arg_0)).orElse(false);
    }

    private Predicate<Username> andToPredicate(QuotaClause clause) {
        QuotaClause.And and = (QuotaClause.And)clause;
        return this.andToPredicate(and);
    }

    private double retrieveUserRatio(Username username) {
        try {
            QuotaRoot quotaRoot = this.quotaRootResolver.forMailAddress(username);
            QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
            Quota storageQuota = quotas.getStorageQuota();
            Quota messageQuota = quotas.getMessageQuota();
            return QuotaRatio.from((Quota)storageQuota, (Quota)messageQuota).max();
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

