/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;

public class ProcessMetrics
implements IMetricSet {
    private final OperatingSystemMXBean sunOsMxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private final Runtime runtime = Runtime.getRuntime();
    private static final String PROCESS = "process";
    private long lastUpdateTime = 0L;
    private volatile long processCpuLoad = 0L;
    private volatile long processCpuTime = 0L;

    public void bindTo(AbstractMetricService metricService) {
        this.collectProcessCpuInfo(metricService);
        this.collectProcessMemInfo(metricService);
        this.collectProcessStatusInfo(metricService);
        this.collectThreadInfo(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.removeProcessCpuInfo(metricService);
        this.removeProcessMemInfo(metricService);
        this.removeProcessStatusInfo(metricService);
        this.removeThreadInfo(metricService);
    }

    private void collectProcessCpuInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.PROCESS_CPU_LOAD.toString(), MetricLevel.CORE, (Object)this.sunOsMxBean, a -> {
            if (System.currentTimeMillis() - this.lastUpdateTime > 10000L) {
                this.lastUpdateTime = System.currentTimeMillis();
                this.processCpuLoad = (long)(this.sunOsMxBean.getProcessCpuLoad() * 100.0);
                this.processCpuTime = this.sunOsMxBean.getProcessCpuTime();
            }
            return this.processCpuLoad;
        }, new String[]{Tag.NAME.toString(), PROCESS});
        metricService.createAutoGauge(SystemMetric.PROCESS_CPU_TIME.toString(), MetricLevel.CORE, (Object)this.sunOsMxBean, bean -> {
            if (System.currentTimeMillis() - this.lastUpdateTime > 10000L) {
                this.lastUpdateTime = System.currentTimeMillis();
                this.processCpuLoad = (long)(this.sunOsMxBean.getProcessCpuLoad() * 100.0);
                this.processCpuTime = this.sunOsMxBean.getProcessCpuTime();
            }
            return this.processCpuTime;
        }, new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void removeProcessCpuInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_CPU_LOAD.toString(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_CPU_TIME.toString(), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void collectProcessMemInfo(AbstractMetricService metricService) {
        Runtime runtime = Runtime.getRuntime();
        metricService.createAutoGauge(SystemMetric.PROCESS_MAX_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.maxMemory(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.createAutoGauge(SystemMetric.PROCESS_TOTAL_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.totalMemory(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.createAutoGauge(SystemMetric.PROCESS_FREE_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.freeMemory(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.createAutoGauge(SystemMetric.PROCESS_USED_MEM.toString(), MetricLevel.IMPORTANT, (Object)this, a -> this.getProcessUsedMemory(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.createAutoGauge(SystemMetric.PROCESS_MEM_RATIO.toString(), MetricLevel.IMPORTANT, (Object)this, a -> Math.round(this.getProcessMemoryRatio()), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void removeProcessMemInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_MAX_MEM.toString(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_TOTAL_MEM.toString(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_FREE_MEM.toString(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_USED_MEM.toString(), new String[]{Tag.NAME.toString(), PROCESS});
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_MEM_RATIO.toString(), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void collectThreadInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.PROCESS_THREADS_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, a -> this.getThreadsCount(), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void removeThreadInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_THREADS_COUNT.toString(), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void collectProcessStatusInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.PROCESS_STATUS.toString(), MetricLevel.IMPORTANT, (Object)this, a -> this.getProcessStatus(), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private void removeProcessStatusInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_STATUS.toString(), new String[]{Tag.NAME.toString(), PROCESS});
    }

    private long getProcessUsedMemory() {
        return this.runtime.totalMemory() - this.runtime.freeMemory();
    }

    private long getProcessStatus() {
        return Thread.currentThread().isAlive() ? 1L : 0L;
    }

    private int getThreadsCount() {
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        return parentThread.activeCount();
    }

    private double getProcessMemoryRatio() {
        long processUsedMemory = this.getProcessUsedMemory();
        long totalPhysicalMemorySize = this.sunOsMxBean.getTotalPhysicalMemorySize();
        return (double)processUsedMemory / (double)totalPhysicalMemorySize * 100.0;
    }
}

