/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedFullPath
implements IFullPath {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedFullPath.class);
    public static final String VECTOR_PLACEHOLDER = "";
    private final IDeviceID deviceID;
    private final List<String> measurementList;
    private final List<IMeasurementSchema> schemaList;
    @Nullable
    private final Set<String> allSensors;

    public AlignedFullPath(IDeviceID deviceID, List<String> measurementList, List<IMeasurementSchema> schemaList) {
        this.deviceID = deviceID;
        this.measurementList = measurementList;
        this.schemaList = schemaList;
        this.allSensors = null;
    }

    public AlignedFullPath(IDeviceID deviceID, List<String> measurementList, List<IMeasurementSchema> schemaList, Set<String> allSensors) {
        this.deviceID = deviceID;
        this.measurementList = measurementList;
        this.schemaList = schemaList;
        this.allSensors = allSensors;
    }

    @Override
    public IDeviceID getDeviceId() {
        return this.deviceID;
    }

    @Override
    public TSDataType getSeriesType() {
        return TSDataType.VECTOR;
    }

    public List<String> getMeasurementList() {
        return this.measurementList;
    }

    public List<IMeasurementSchema> getSchemaList() {
        return this.schemaList;
    }

    public int getColumnNum() {
        return this.measurementList.size();
    }

    public Set<String> getAllSensors() {
        if (this.allSensors != null) {
            return this.allSensors;
        }
        HashSet<String> res = new HashSet<String>(this.measurementList);
        res.add(VECTOR_PLACEHOLDER);
        return res;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.deviceID.ramBytesUsed() + this.measurementList.stream().mapToLong(RamUsageEstimator::sizeOf).sum() * 2L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignedFullPath that = (AlignedFullPath)o;
        return Objects.equals(this.deviceID, that.deviceID) && Objects.equals(this.measurementList, that.measurementList);
    }

    public int hashCode() {
        return Objects.hash(this.deviceID, this.measurementList);
    }
}

