/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.task.subtask;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtask;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionSinkSubtask
extends PipeSinkSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionSinkSubtask.class);
    private final String topicName;
    private final String consumerGroupId;

    public SubscriptionSinkSubtask(String taskID, long creationTime, String attributeSortedString, int connectorIndex, UnboundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector, String topicName, String consumerGroupId) {
        super(taskID, creationTime, attributeSortedString, connectorIndex, inputPendingQueue, outputPipeConnector);
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public UnboundedBlockingPendingQueue<Event> getInputPendingQueue() {
        return this.inputPendingQueue;
    }

    protected void registerCallbackHookAfterSubmit(ListenableFuture<Boolean> future) {
        Futures.addCallback(future, (FutureCallback)this, (Executor)this.subtaskCallbackListeningExecutor);
    }

    public synchronized void onFailure(Throwable throwable) {
        this.isSubmitted = false;
        this.submitSelf();
    }

    @Override
    protected boolean executeOnce() {
        if (this.isClosed.get()) {
            return false;
        }
        return SubscriptionAgent.broker().executePrefetch(this.consumerGroupId, this.topicName);
    }
}

