/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TClusterParameters;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowVariablesTask
implements IConfigTask {
    private static void buildTSBlock(TsBlockBuilder builder, Binary parameter, Binary value) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(parameter);
        builder.getColumnBuilder(1).writeBinary(value);
        builder.declarePosition();
    }

    public static void buildTSBlock(TShowVariablesResp showVariablesResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showVariablesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        TClusterParameters clusterParameters = showVariablesResp.getClusterParameters();
        ShowVariablesTask.buildTSBlock(builder, new Binary("ClusterName", TSFileConfig.STRING_CHARSET), new Binary(clusterParameters.getClusterName(), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DataReplicationFactor", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getDataReplicationFactor()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SchemaReplicationFactor", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getSchemaReplicationFactor()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DataRegionConsensusProtocolClass", TSFileConfig.STRING_CHARSET), new Binary(clusterParameters.getDataRegionConsensusProtocolClass(), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SchemaRegionConsensusProtocolClass", TSFileConfig.STRING_CHARSET), new Binary(clusterParameters.getSchemaRegionConsensusProtocolClass(), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("ConfigNodeConsensusProtocolClass", TSFileConfig.STRING_CHARSET), new Binary(clusterParameters.getConfigNodeConsensusProtocolClass(), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("TimePartitionOrigin", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getTimePartitionOrigin()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("TimePartitionInterval", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getTimePartitionInterval()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("ReadConsistencyLevel", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getReadConsistencyLevel()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SchemaRegionPerDataNode", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getSchemaRegionPerDataNode()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DataRegionPerDataNode", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getDataRegionPerDataNode()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SeriesSlotNum", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getSeriesPartitionSlotNum()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SeriesSlotExecutorClass", TSFileConfig.STRING_CHARSET), new Binary(clusterParameters.getSeriesPartitionExecutorClass(), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DiskSpaceWarningThreshold", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getDiskSpaceWarningThreshold()), TSFileConfig.STRING_CHARSET));
        ShowVariablesTask.buildTSBlock(builder, new Binary("TimestampPrecision", TSFileConfig.STRING_CHARSET), new Binary(String.valueOf(clusterParameters.getTimestampPrecision()), TSFileConfig.STRING_CHARSET));
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowClusterParametersHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showClusterParameters();
    }
}

