/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.udf.UDFManagementService;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDFParametersFactory;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.UDAF;
import org.apache.iotdb.udf.api.customizer.config.UDAFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDAFAccumulator
implements Accumulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDAFAccumulator.class);
    private final String functionName;
    private final UDAFConfigurations configurations;
    private State state;
    private UDAF udaf;

    public UDAFAccumulator(String functionName, List<Expression> childrenExpressions, TSDataType childrenExpressionDataTypes, Map<String, String> attributes, boolean isInputRaw) {
        this.functionName = functionName;
        this.configurations = new UDAFConfigurations();
        List<String> childExpressionStrings = childrenExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList());
        this.beforeStart(childExpressionStrings, Collections.singletonList(childrenExpressionDataTypes), attributes, isInputRaw);
    }

    private void beforeStart(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes, boolean isInputRaw) {
        this.reflectAndValidateUDF(childExpressions, childExpressionDataTypes, attributes, isInputRaw);
        this.configurations.check();
    }

    private void reflectAndValidateUDF(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes, boolean isInputRaw) {
        this.udaf = UDFManagementService.getInstance().reflect(this.functionName, UDAF.class);
        this.state = this.udaf.createState();
        UDFParameters parameters = UDFParametersFactory.buildUdfParameters(childExpressions, childExpressionDataTypes, attributes);
        if (isInputRaw) {
            try {
                this.udaf.validate(new UDFParameterValidator(parameters));
            }
            catch (Exception e) {
                this.onError("validate(UDFParameterValidator)", e);
            }
        }
        try {
            this.udaf.beforeStart(parameters, this.configurations);
        }
        catch (Exception e) {
            this.onError("beforeStart(UDFParameters, UDAFConfigurations)", e);
        }
    }

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        Column timeColumn = columns[0];
        for (int i = 0; i < columns.length - 1; ++i) {
            columns[i] = columns[i + 1];
        }
        columns[columns.length - 1] = timeColumn;
        this.udaf.addInput(this.state, columns, bitMap);
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of UDAF should be 1");
        State otherState = this.udaf.createState();
        Binary otherStateBinary = partialResult[0].getBinary(0);
        otherState.deserialize(otherStateBinary.getValues());
        this.udaf.combineState(this.state, otherState);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFinal(Column finalResult) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of UDAF should be 1");
        byte[] bytes = this.state.serialize();
        columnBuilders[0].writeBinary(new Binary(bytes));
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        ResultValue resultValue = new ResultValue(columnBuilder);
        this.udaf.outputFinal(this.state, resultValue);
    }

    @Override
    public void removeIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of UDAF should be 1");
        State removedState = this.udaf.createState();
        Binary removedStateBinary = partialResult[0].getBinary(0);
        removedState.deserialize(removedStateBinary.getValues());
        this.udaf.removeState(this.state, removedState);
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.TEXT};
    }

    @Override
    public TSDataType getFinalType() {
        return UDFDataTypeTransformer.transformToTsDataType((Type)this.configurations.getOutputDataType());
    }

    private void onError(String methodName, Exception e) {
        LOGGER.warn("Error occurred during executing UDAF, please check whether the implementation of UDF is correct according to the udf-api description.", (Throwable)e);
        throw new RuntimeException(String.format("Error occurred during executing UDAF#%s: %s, please check whether the implementation of UDF is correct according to the udf-api description.", methodName, System.lineSeparator()) + e);
    }

    public UDAFConfigurations getConfigurations() {
        return this.configurations;
    }
}

