/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class OutputColumn {
    private final List<InputLocation> sourceLocations;
    private final boolean overlapped;

    public OutputColumn(InputLocation inputLocation) {
        this.sourceLocations = ImmutableList.of((Object)inputLocation);
        this.overlapped = false;
    }

    public OutputColumn(List<InputLocation> sourceLocations, boolean overlapped) {
        Preconditions.checkArgument((sourceLocations != null && !sourceLocations.isEmpty() ? 1 : 0) != 0, (Object)"size of sourceLocations should be larger than 0");
        this.sourceLocations = sourceLocations;
        this.overlapped = overlapped;
    }

    public List<InputLocation> getSourceLocations() {
        return this.sourceLocations;
    }

    public boolean isOverlapped() {
        return this.overlapped;
    }

    public boolean isSingleInputColumn() {
        return this.sourceLocations.size() == 1;
    }

    public InputLocation getSourceLocation(int index) {
        Preconditions.checkArgument((index < this.sourceLocations.size() ? 1 : 0) != 0, (Object)"index is not valid");
        return this.sourceLocations.get(index);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.sourceLocations.size(), (ByteBuffer)byteBuffer);
        for (InputLocation sourceLocation : this.sourceLocations) {
            sourceLocation.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.overlapped, (ByteBuffer)byteBuffer);
    }

    public static OutputColumn deserialize(ByteBuffer byteBuffer) {
        ImmutableList.Builder sourceLocations = ImmutableList.builder();
        for (int sourceLocationSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); sourceLocationSize > 0; --sourceLocationSize) {
            sourceLocations.add((Object)InputLocation.deserialize(byteBuffer));
        }
        boolean overlapped = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        return new OutputColumn((List<InputLocation>)sourceLocations.build(), overlapped);
    }
}

