/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric.overview;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.manager.pipe.coordinator.PipeManager;
import org.apache.iotdb.confignode.manager.pipe.coordinator.task.PipeTaskCoordinator;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeTaskInfoMetrics
implements IMetricSet {
    private final PipeManager pipeManager;
    private static final String RUNNING = "running";
    private static final String DROPPED = "dropped";
    private static final String USER_STOPPED = "userStopped";
    private static final String EXCEPTION_STOPPED = "exceptionStopped";

    public PipeTaskInfoMetrics(PipeManager pipeManager) {
        this.pipeManager = pipeManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        PipeTaskCoordinator coordinator = this.pipeManager.getPipeTaskCoordinator();
        metricService.createAutoGauge(Metric.PIPE_TASK_STATUS.toString(), MetricLevel.IMPORTANT, (Object)coordinator, PipeTaskCoordinator::runningPipeCount, new String[]{Tag.STATUS.toString(), RUNNING});
        metricService.createAutoGauge(Metric.PIPE_TASK_STATUS.toString(), MetricLevel.IMPORTANT, (Object)coordinator, PipeTaskCoordinator::droppedPipeCount, new String[]{Tag.STATUS.toString(), DROPPED});
        metricService.createAutoGauge(Metric.PIPE_TASK_STATUS.toString(), MetricLevel.IMPORTANT, (Object)coordinator, PipeTaskCoordinator::userStoppedPipeCount, new String[]{Tag.STATUS.toString(), USER_STOPPED});
        metricService.createAutoGauge(Metric.PIPE_TASK_STATUS.toString(), MetricLevel.IMPORTANT, (Object)coordinator, PipeTaskCoordinator::exceptionStoppedPipeCount, new String[]{Tag.STATUS.toString(), EXCEPTION_STOPPED});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_TASK_STATUS.toString(), new String[]{Tag.STATUS.toString(), RUNNING});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_TASK_STATUS.toString(), new String[]{Tag.STATUS.toString(), DROPPED});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_TASK_STATUS.toString(), new String[]{Tag.STATUS.toString(), USER_STOPPED});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_TASK_STATUS.toString(), new String[]{Tag.STATUS.toString(), EXCEPTION_STOPPED});
    }
}

