/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;

public class InTransformer
extends UnaryTransformer {
    private final Satisfy satisfy;
    private Set<Integer> intSet;
    private Set<Long> longSet;
    private Set<Float> floatSet;
    private Set<Double> doubleSet;
    private Set<Boolean> booleanSet;
    private Set<String> stringSet;

    public InTransformer(LayerReader layerReader, boolean isNotIn, Set<String> values) {
        super(layerReader);
        this.satisfy = isNotIn ? new NotInSatisfy() : new InSatisfy();
        this.initTypedSet(values);
    }

    private void initTypedSet(Set<String> values) {
        switch (this.layerReaderDataType) {
            case INT32: 
            case DATE: {
                this.intSet = new HashSet<Integer>();
                for (String value : values) {
                    this.intSet.add(Integer.valueOf(value));
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longSet = new HashSet<Long>();
                for (String value : values) {
                    this.longSet.add(Long.valueOf(value));
                }
                break;
            }
            case FLOAT: {
                this.floatSet = new HashSet<Float>();
                for (String value : values) {
                    this.floatSet.add(Float.valueOf(value));
                }
                break;
            }
            case DOUBLE: {
                this.doubleSet = new HashSet<Double>();
                for (String value : values) {
                    this.doubleSet.add(Double.valueOf(value));
                }
                break;
            }
            case BOOLEAN: {
                this.booleanSet = new HashSet<Boolean>();
                for (String value : values) {
                    this.booleanSet.add(Boolean.valueOf(value));
                }
                break;
            }
            case TEXT: 
            case STRING: {
                this.stringSet = values;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported data type: " + this.layerReaderDataType);
            }
        }
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }

    @Override
    protected void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException, IOException {
        switch (this.layerReaderDataType) {
            case INT32: 
            case DATE: {
                this.transformInt(columns, builder);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.transformLong(columns, builder);
                return;
            }
            case FLOAT: {
                this.transformFloat(columns, builder);
                return;
            }
            case DOUBLE: {
                this.transformDouble(columns, builder);
                return;
            }
            case BOOLEAN: {
                this.transformBoolean(columns, builder);
                return;
            }
            case TEXT: 
            case STRING: {
                this.transformBinary(columns, builder);
                return;
            }
        }
        throw new QueryProcessException("unsupported data type: " + this.layerReaderDataType);
    }

    private void transformInt(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        int[] values = columns[0].getInts();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.satisfy.of(values[i]);
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformLong(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        long[] values = columns[0].getLongs();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.satisfy.of(values[i]);
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformFloat(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        float[] values = columns[0].getFloats();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.satisfy.of(values[i]);
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformDouble(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        double[] values = columns[0].getDoubles();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.satisfy.of(values[i]);
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformBoolean(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        boolean[] values = columns[0].getBooleans();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.satisfy.of(values[i]);
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformBinary(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        Binary[] values = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.satisfy.of(values[i].getStringValue(TSFileConfig.STRING_CHARSET));
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }

    private class NotInSatisfy
    implements Satisfy {
        private NotInSatisfy() {
        }

        @Override
        public boolean of(int intValue) {
            return !InTransformer.this.intSet.contains(intValue);
        }

        @Override
        public boolean of(long longValue) {
            return !InTransformer.this.longSet.contains(longValue);
        }

        @Override
        public boolean of(float floatValue) {
            return !InTransformer.this.floatSet.contains(Float.valueOf(floatValue));
        }

        @Override
        public boolean of(double doubleValue) {
            return !InTransformer.this.doubleSet.contains(doubleValue);
        }

        @Override
        public boolean of(boolean booleanValue) {
            return !InTransformer.this.booleanSet.contains(booleanValue);
        }

        @Override
        public boolean of(String stringValue) {
            return !InTransformer.this.stringSet.contains(stringValue);
        }
    }

    private class InSatisfy
    implements Satisfy {
        private InSatisfy() {
        }

        @Override
        public boolean of(int intValue) {
            return InTransformer.this.intSet.contains(intValue);
        }

        @Override
        public boolean of(long longValue) {
            return InTransformer.this.longSet.contains(longValue);
        }

        @Override
        public boolean of(float floatValue) {
            return InTransformer.this.floatSet.contains(Float.valueOf(floatValue));
        }

        @Override
        public boolean of(double doubleValue) {
            return InTransformer.this.doubleSet.contains(doubleValue);
        }

        @Override
        public boolean of(boolean booleanValue) {
            return InTransformer.this.booleanSet.contains(booleanValue);
        }

        @Override
        public boolean of(String stringValue) {
            return InTransformer.this.stringSet.contains(stringValue);
        }
    }

    private static interface Satisfy {
        public boolean of(int var1);

        public boolean of(long var1);

        public boolean of(float var1);

        public boolean of(double var1);

        public boolean of(boolean var1);

        public boolean of(String var1);
    }
}

