/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class EnumValueType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7594");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7616");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=8251");
    private final Long value;
    private final LocalizedText displayName;
    private final LocalizedText description;

    public EnumValueType(Long value, LocalizedText displayName, LocalizedText description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Long getValue() {
        return this.value;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    protected EnumValueType(EnumValueTypeBuilder<?, ?> b) {
        super(b);
        this.value = ((EnumValueTypeBuilder)b).value;
        this.displayName = ((EnumValueTypeBuilder)b).displayName;
        this.description = ((EnumValueTypeBuilder)b).description;
    }

    public static EnumValueTypeBuilder<?, ?> builder() {
        return new EnumValueTypeBuilderImpl();
    }

    public EnumValueTypeBuilder<?, ?> toBuilder() {
        return new EnumValueTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumValueType)) {
            return false;
        }
        EnumValueType other = (EnumValueType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$value = this.getValue();
        Long other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        LocalizedText this$displayName = this.getDisplayName();
        LocalizedText other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        LocalizedText this$description = this.getDescription();
        LocalizedText other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !((Object)this$description).equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnumValueType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        LocalizedText $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        LocalizedText $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EnumValueType(value=" + this.getValue() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    private static final class EnumValueTypeBuilderImpl
    extends EnumValueTypeBuilder<EnumValueType, EnumValueTypeBuilderImpl> {
        private EnumValueTypeBuilderImpl() {
        }

        @Override
        protected EnumValueTypeBuilderImpl self() {
            return this;
        }

        @Override
        public EnumValueType build() {
            return new EnumValueType(this);
        }
    }

    public static abstract class EnumValueTypeBuilder<C extends EnumValueType, B extends EnumValueTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Long value;
        private LocalizedText displayName;
        private LocalizedText description;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EnumValueTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EnumValueType instance, EnumValueTypeBuilder<?, ?> b) {
            b.value(instance.value);
            b.displayName(instance.displayName);
            b.description(instance.description);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B value(Long value) {
            this.value = value;
            return (B)this.self();
        }

        public B displayName(LocalizedText displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        public B description(LocalizedText description) {
            this.description = description;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EnumValueType.EnumValueTypeBuilder(super=" + super.toString() + ", value=" + this.value + ", displayName=" + this.displayName + ", description=" + this.description + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EnumValueType> {
        @Override
        public Class<EnumValueType> getType() {
            return EnumValueType.class;
        }

        @Override
        public EnumValueType decode(SerializationContext context, UaDecoder decoder) {
            Long value = decoder.readInt64("Value");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            return new EnumValueType(value, displayName, description);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EnumValueType value) {
            encoder.writeInt64("Value", value.getValue());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
        }
    }
}

