/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class DropModelInNodePlan
extends ConfigPhysicalPlan {
    private int nodeId;

    public DropModelInNodePlan() {
        super(ConfigPhysicalPlanType.DropModelInNode);
    }

    public DropModelInNodePlan(int nodeId) {
        super(ConfigPhysicalPlanType.DropModelInNode);
        this.nodeId = nodeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.nodeId);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.nodeId = buffer.getInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DropModelInNodePlan)) {
            return false;
        }
        DropModelInNodePlan that = (DropModelInNodePlan)o;
        return this.nodeId == that.nodeId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodeId);
    }
}

