/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowseResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=522");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=524");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=523");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15183");
    private final StatusCode statusCode;
    private final ByteString continuationPoint;
    private final ReferenceDescription[] references;

    public BrowseResult(StatusCode statusCode, ByteString continuationPoint, ReferenceDescription[] references) {
        this.statusCode = statusCode;
        this.continuationPoint = continuationPoint;
        this.references = references;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public ReferenceDescription[] getReferences() {
        return this.references;
    }

    protected BrowseResult(BrowseResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((BrowseResultBuilder)b).statusCode;
        this.continuationPoint = ((BrowseResultBuilder)b).continuationPoint;
        this.references = ((BrowseResultBuilder)b).references;
    }

    public static BrowseResultBuilder<?, ?> builder() {
        return new BrowseResultBuilderImpl();
    }

    public BrowseResultBuilder<?, ?> toBuilder() {
        return new BrowseResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowseResult)) {
            return false;
        }
        BrowseResult other = (BrowseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        ByteString this$continuationPoint = this.getContinuationPoint();
        ByteString other$continuationPoint = other.getContinuationPoint();
        if (this$continuationPoint == null ? other$continuationPoint != null : !((Object)this$continuationPoint).equals(other$continuationPoint)) {
            return false;
        }
        return Arrays.deepEquals(this.getReferences(), other.getReferences());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        ByteString $continuationPoint = this.getContinuationPoint();
        result = result * 59 + ($continuationPoint == null ? 43 : ((Object)$continuationPoint).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReferences());
        return result;
    }

    @Override
    public String toString() {
        return "BrowseResult(statusCode=" + this.getStatusCode() + ", continuationPoint=" + this.getContinuationPoint() + ", references=" + Arrays.deepToString(this.getReferences()) + ")";
    }

    private static final class BrowseResultBuilderImpl
    extends BrowseResultBuilder<BrowseResult, BrowseResultBuilderImpl> {
        private BrowseResultBuilderImpl() {
        }

        @Override
        protected BrowseResultBuilderImpl self() {
            return this;
        }

        @Override
        public BrowseResult build() {
            return new BrowseResult(this);
        }
    }

    public static abstract class BrowseResultBuilder<C extends BrowseResult, B extends BrowseResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private ByteString continuationPoint;
        private ReferenceDescription[] references;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowseResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowseResult instance, BrowseResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.continuationPoint(instance.continuationPoint);
            b.references(instance.references);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B continuationPoint(ByteString continuationPoint) {
            this.continuationPoint = continuationPoint;
            return (B)this.self();
        }

        public B references(ReferenceDescription[] references) {
            this.references = references;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowseResult.BrowseResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", continuationPoint=" + this.continuationPoint + ", references=" + Arrays.deepToString(this.references) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowseResult> {
        @Override
        public Class<BrowseResult> getType() {
            return BrowseResult.class;
        }

        @Override
        public BrowseResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ReferenceDescription[] references = (ReferenceDescription[])decoder.readStructArray("References", ReferenceDescription.TYPE_ID);
            return new BrowseResult(statusCode, continuationPoint, references);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowseResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceDescription.TYPE_ID);
        }
    }
}

