/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.session.subscription.consumer.AckStrategy;
import org.apache.iotdb.session.subscription.consumer.ConsumeListener;
import org.apache.iotdb.session.subscription.consumer.ConsumeResult;
import org.apache.iotdb.session.subscription.consumer.SubscriptionConsumer;
import org.apache.iotdb.session.subscription.consumer.SubscriptionExecutorServiceManager;
import org.apache.iotdb.session.subscription.consumer.SubscriptionPullConsumer;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import org.apache.iotdb.session.subscription.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPushConsumer
extends SubscriptionConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPushConsumer.class);
    private final AckStrategy ackStrategy;
    private final ConsumeListener consumeListener;
    private final long autoPollIntervalMs;
    private final long autoPollTimeoutMs;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);

    protected SubscriptionPushConsumer(Builder builder) {
        super(builder);
        this.ackStrategy = builder.ackStrategy;
        this.consumeListener = builder.consumeListener;
        this.autoPollIntervalMs = builder.autoPollIntervalMs;
        this.autoPollTimeoutMs = builder.autoPollTimeoutMs;
    }

    public SubscriptionPushConsumer(Properties config) {
        this(config, (AckStrategy)((Object)config.getOrDefault((Object)"ack-strategy", (Object)AckStrategy.defaultValue())), (ConsumeListener)config.getOrDefault((Object)"consume-listener", message -> ConsumeResult.SUCCESS), (Long)config.getOrDefault((Object)"auto-poll-interval-ms", (Object)100L), (Long)config.getOrDefault((Object)"auto-poll-timeout-ms", (Object)10000L));
    }

    private SubscriptionPushConsumer(Properties config, AckStrategy ackStrategy, ConsumeListener consumeListener, long autoPollIntervalMs, long autoPollTimeoutMs) {
        super(new Builder().ackStrategy(ackStrategy).consumeListener(consumeListener).autoPollIntervalMs(autoPollIntervalMs).autoPollTimeoutMs(autoPollTimeoutMs), config);
        this.ackStrategy = ackStrategy;
        this.consumeListener = consumeListener;
        this.autoPollIntervalMs = Math.max(autoPollIntervalMs, 1L);
        this.autoPollTimeoutMs = Math.max(autoPollTimeoutMs, 1000L);
    }

    @Override
    public synchronized void open() throws SubscriptionException {
        if (!this.isClosed.get()) {
            return;
        }
        super.open();
        this.isClosed.set(false);
        this.submitAutoPollWorker();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed.get()) {
            return;
        }
        super.close();
        this.isClosed.set(true);
    }

    @Override
    boolean isClosed() {
        return this.isClosed.get();
    }

    private void submitAutoPollWorker() {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{SubscriptionExecutorServiceManager.submitAutoPollWorker(() -> {
            if (this.isClosed()) {
                if (Objects.nonNull(future[0])) {
                    future[0].cancel(false);
                    LOGGER.info("SubscriptionPushConsumer {} cancel auto poll worker", (Object)this);
                }
                return;
            }
            new AutoPollWorker().run();
        }, this.autoPollIntervalMs)};
        LOGGER.info("SubscriptionPushConsumer {} submit auto poll worker", (Object)this);
    }

    public String toString() {
        return "SubscriptionPushConsumer" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("ackStrategy", this.ackStrategy.toString());
        return coreReportMessage;
    }

    @Override
    protected Map<String, String> allReportMessage() {
        Map<String, String> allReportMessage = super.allReportMessage();
        allReportMessage.put("ackStrategy", this.ackStrategy.toString());
        allReportMessage.put("autoPollIntervalMs", String.valueOf(this.autoPollIntervalMs));
        allReportMessage.put("autoPollTimeoutMs", String.valueOf(this.autoPollTimeoutMs));
        return allReportMessage;
    }

    public static class Builder
    extends SubscriptionConsumer.Builder {
        private AckStrategy ackStrategy = AckStrategy.defaultValue();
        private ConsumeListener consumeListener = message -> ConsumeResult.SUCCESS;
        private long autoPollIntervalMs = 100L;
        private long autoPollTimeoutMs = 10000L;

        @Override
        public Builder host(String host) {
            super.host(host);
            return this;
        }

        @Override
        public Builder port(int port) {
            super.port(port);
            return this;
        }

        @Override
        public Builder nodeUrls(List<String> nodeUrls) {
            super.nodeUrls(nodeUrls);
            return this;
        }

        @Override
        public Builder username(String username) {
            super.username(username);
            return this;
        }

        @Override
        public Builder password(String password) {
            super.password(password);
            return this;
        }

        @Override
        public Builder consumerId(String consumerId) {
            super.consumerId(consumerId);
            return this;
        }

        @Override
        public Builder consumerGroupId(String consumerGroupId) {
            super.consumerGroupId(consumerGroupId);
            return this;
        }

        @Override
        public Builder heartbeatIntervalMs(long heartbeatIntervalMs) {
            super.heartbeatIntervalMs(heartbeatIntervalMs);
            return this;
        }

        @Override
        public Builder endpointsSyncIntervalMs(long endpointsSyncIntervalMs) {
            super.endpointsSyncIntervalMs(endpointsSyncIntervalMs);
            return this;
        }

        @Override
        public Builder fileSaveDir(String fileSaveDir) {
            super.fileSaveDir(fileSaveDir);
            return this;
        }

        @Override
        public Builder fileSaveFsync(boolean fileSaveFsync) {
            super.fileSaveFsync(fileSaveFsync);
            return this;
        }

        @Override
        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            super.thriftMaxFrameSize(thriftMaxFrameSize);
            return this;
        }

        @Override
        public Builder maxPollParallelism(int maxPollParallelism) {
            super.maxPollParallelism(maxPollParallelism);
            return this;
        }

        public Builder ackStrategy(AckStrategy ackStrategy) {
            this.ackStrategy = ackStrategy;
            return this;
        }

        public Builder consumeListener(ConsumeListener consumeListener) {
            this.consumeListener = consumeListener;
            return this;
        }

        public Builder autoPollIntervalMs(long autoPollIntervalMs) {
            this.autoPollIntervalMs = Math.max(autoPollIntervalMs, 1L);
            return this;
        }

        public Builder autoPollTimeoutMs(long autoPollTimeoutMs) {
            this.autoPollTimeoutMs = Math.max(autoPollTimeoutMs, 1000L);
            return this;
        }

        @Override
        public SubscriptionPullConsumer buildPullConsumer() {
            throw new SubscriptionException("SubscriptionPushConsumer.Builder do not support build pull consumer.");
        }

        @Override
        public SubscriptionPushConsumer buildPushConsumer() {
            return new SubscriptionPushConsumer(this);
        }
    }

    class AutoPollWorker
    implements Runnable {
        AutoPollWorker() {
        }

        @Override
        public void run() {
            if (SubscriptionPushConsumer.this.isClosed()) {
                return;
            }
            if (SubscriptionPushConsumer.this.subscribedTopics.isEmpty()) {
                return;
            }
            try {
                List<SubscriptionMessage> messages = SubscriptionPushConsumer.this.multiplePoll(SubscriptionPushConsumer.this.subscribedTopics.keySet(), SubscriptionPushConsumer.this.autoPollTimeoutMs);
                if (messages.isEmpty()) {
                    LOGGER.info("SubscriptionPushConsumer {} poll empty message from topics {} after {} millisecond(s)", new Object[]{this, CollectionUtils.getLimitedString(SubscriptionPushConsumer.this.subscribedTopics.keySet(), 32), SubscriptionPushConsumer.this.autoPollTimeoutMs});
                    return;
                }
                if (SubscriptionPushConsumer.this.ackStrategy.equals((Object)AckStrategy.BEFORE_CONSUME)) {
                    SubscriptionPushConsumer.this.ack(messages);
                }
                ArrayList<SubscriptionMessage> messagesToAck = new ArrayList<SubscriptionMessage>();
                ArrayList<SubscriptionMessage> messagesToNack = new ArrayList<SubscriptionMessage>();
                for (SubscriptionMessage message : messages) {
                    try {
                        ConsumeResult consumeResult = SubscriptionPushConsumer.this.consumeListener.onReceive(message);
                        if (Objects.equals((Object)ConsumeResult.SUCCESS, (Object)consumeResult)) {
                            messagesToAck.add(message);
                            continue;
                        }
                        LOGGER.warn("Consumer listener result failure when consuming message: {}", (Object)message);
                        messagesToNack.add(message);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Consumer listener raised an exception while consuming message: {}", (Object)message, (Object)e);
                        messagesToNack.add(message);
                    }
                }
                if (SubscriptionPushConsumer.this.ackStrategy.equals((Object)AckStrategy.AFTER_CONSUME)) {
                    SubscriptionPushConsumer.this.ack(messagesToAck);
                    SubscriptionPushConsumer.this.nack(messagesToNack);
                }
            }
            catch (Exception e) {
                LOGGER.warn("something unexpected happened when auto poll messages...", (Throwable)e);
            }
        }
    }
}

