/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.server.storage.SnapshotManager;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.util.SizeInBytes;

public final class StorageImplUtils {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];

    private StorageImplUtils() {
    }

    public static SnapshotManager newSnapshotManager(RaftPeerId id, Supplier<RaftStorageDirectory> dir, StateMachineStorage smStorage) {
        return new SnapshotManager(id, dir, smStorage);
    }

    public static RaftStorageImpl newRaftStorage(File dir, SizeInBytes freeSpaceMin, RaftStorage.StartupOption option, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy) {
        return new RaftStorageImpl(dir, freeSpaceMin, option, logCorruptionPolicy);
    }

    static List<File> getExistingStorageSubs(List<File> volumes, String targetSubDir, Map<File, Integer> dirsPerVol) {
        return volumes.stream().flatMap(volume -> {
            File[] dirs = Optional.ofNullable(volume.listFiles()).orElse(EMPTY_FILE_ARRAY);
            Optional.ofNullable(dirsPerVol).ifPresent(map -> map.put(volume, dirs.length));
            return Arrays.stream(dirs);
        }).filter(dir -> targetSubDir.equals(dir.getName())).collect(Collectors.toList());
    }

    static File chooseMin(Map<File, Integer> dirsPerVol) throws IOException {
        return dirsPerVol.entrySet().stream().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(() -> new IOException("No storage directory found."));
    }

    public static RaftStorageImpl initRaftStorage(String storageDirName, RaftStorage.StartupOption option, RaftProperties properties) throws IOException {
        return new Op(storageDirName, option, properties).run();
    }

    private static class Op {
        private final String storageDirName;
        private final RaftStorage.StartupOption option;
        private final SizeInBytes freeSpaceMin;
        private final RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy;
        private final List<File> dirsInConf;
        private final List<File> existingSubs;
        private final Map<File, Integer> dirsPerVol = new HashMap<File, Integer>();

        Op(String storageDirName, RaftStorage.StartupOption option, RaftProperties properties) {
            this.storageDirName = storageDirName;
            this.option = option;
            this.freeSpaceMin = RaftServerConfigKeys.storageFreeSpaceMin((RaftProperties)properties);
            this.logCorruptionPolicy = RaftServerConfigKeys.Log.corruptionPolicy((RaftProperties)properties);
            this.dirsInConf = RaftServerConfigKeys.storageDir((RaftProperties)properties);
            this.existingSubs = StorageImplUtils.getExistingStorageSubs(this.dirsInConf, this.storageDirName, this.dirsPerVol);
        }

        RaftStorageImpl run() throws IOException {
            if (this.option == RaftStorage.StartupOption.FORMAT) {
                return this.format();
            }
            if (this.option == RaftStorage.StartupOption.RECOVER) {
                RaftStorageImpl recovered = this.recover();
                return recovered != null ? recovered : this.format();
            }
            throw new IllegalArgumentException("Illegal option: " + this.option);
        }

        private RaftStorageImpl format() throws IOException {
            if (!this.existingSubs.isEmpty()) {
                throw new IOException("Failed to " + this.option + ": One or more existing directories found " + this.existingSubs + " for " + this.storageDirName);
            }
            while (!this.dirsPerVol.isEmpty()) {
                File vol = StorageImplUtils.chooseMin(this.dirsPerVol);
                File dir = new File(vol, this.storageDirName);
                try {
                    RaftStorageImpl storage = StorageImplUtils.newRaftStorage(dir, this.freeSpaceMin, RaftStorage.StartupOption.FORMAT, this.logCorruptionPolicy);
                    storage.initialize();
                    return storage;
                }
                catch (Throwable e) {
                    RaftServer.Division.LOG.warn("Failed to initialize a new directory " + dir.getAbsolutePath(), e);
                    this.dirsPerVol.remove(vol);
                }
            }
            throw new IOException("Failed to FORMAT a new storage dir for " + this.storageDirName + " from " + this.dirsInConf);
        }

        private RaftStorageImpl recover() throws IOException {
            int size = this.existingSubs.size();
            if (size > 1) {
                throw new IOException("Failed to " + this.option + ": More than one existing directories found " + this.existingSubs + " for " + this.storageDirName);
            }
            if (size == 0) {
                if (this.dirsInConf.size() == 1) {
                    return null;
                }
                throw new IOException("Failed to " + this.option + ": Storage directory not found for " + this.storageDirName + " from " + this.dirsInConf);
            }
            File dir = this.existingSubs.get(0);
            try {
                RaftStorageImpl storage = StorageImplUtils.newRaftStorage(dir, this.freeSpaceMin, RaftStorage.StartupOption.RECOVER, this.logCorruptionPolicy);
                storage.initialize();
                return storage;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException("Failed to initialize the existing directory " + dir.getAbsolutePath(), e);
            }
        }
    }
}

