#!/usr/bin/env bash
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#


BLACK='\033[0;30m'
RED='\033[0;31m'
YELLOW='\033[0;33m'
DEFAULT='\033[0m'

function log_warning() {
  local message="${1}"

  echo >&2 -e "${YELLOW}WARN ${message}${DEFAULT}"
}

function log_error() {
  local message="${1}"

  echo >&2 -e "${RED}ERROR ${message}${DEFAULT}"
}

function log_info() {
  local message="${1}"

  echo >&2 -e "INFO ${message}"
}
