/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.elb;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClientBuilder;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.util.StringUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryElbIpFinder
extends TcpDiscoveryIpFinderAdapter {
    private AmazonElasticLoadBalancing amazonELBClient;
    private AmazonEC2 amazonEC2Client;
    private AWSCredentialsProvider credsProvider;
    private String region;
    private String loadBalancerName;

    public TcpDiscoveryElbIpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.initClients();
        ArrayList<String> instanceIds = new ArrayList<String>();
        DescribeLoadBalancersRequest req = new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{this.loadBalancerName});
        List descs = this.amazonELBClient.describeLoadBalancers(req).getLoadBalancerDescriptions();
        for (LoadBalancerDescription desc : descs) {
            for (Instance instance : desc.getInstances()) {
                instanceIds.add(instance.getInstanceId());
            }
        }
        DescribeInstancesRequest instReq = new DescribeInstancesRequest().withInstanceIds(instanceIds);
        List reservations = this.amazonEC2Client.describeInstances(instReq).getReservations();
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (Reservation reservation : reservations) {
            List instances = reservation.getInstances();
            for (com.amazonaws.services.ec2.model.Instance instance : instances) {
                addrs.add(new InetSocketAddress(instance.getPrivateIpAddress(), 0));
            }
        }
        return addrs;
    }

    private void initClients() {
        if (this.credsProvider == null || StringUtils.isNullOrEmpty((String)this.loadBalancerName) || StringUtils.isNullOrEmpty((String)this.region)) {
            throw new IgniteSpiException("One or more configuration parameters are invalid [setCredentialsProvider=" + this.credsProvider + ", setRegion=" + this.region + ", setLoadBalancerName=" + this.loadBalancerName + "]");
        }
        if (this.amazonEC2Client == null) {
            this.amazonEC2Client = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withRegion(this.region)).withCredentials(this.credsProvider)).build();
        }
        if (this.amazonELBClient == null) {
            this.amazonELBClient = (AmazonElasticLoadBalancing)((AmazonElasticLoadBalancingClientBuilder)((AmazonElasticLoadBalancingClientBuilder)AmazonElasticLoadBalancingClientBuilder.standard().withRegion(this.region)).withCredentials(this.credsProvider)).build();
        }
    }

    @IgniteSpiConfiguration(optional=false)
    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    @IgniteSpiConfiguration(optional=false)
    public void setRegion(String region) {
        this.region = region;
    }

    @IgniteSpiConfiguration(optional=false)
    public void setCredentialsProvider(AWSCredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }
}

