/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.closure;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.Status;

public abstract class ReadIndexClosure
implements Closure {
    private static final IgniteLogger LOG = Loggers.forClass(ReadIndexClosure.class);
    private static final AtomicIntegerFieldUpdater<ReadIndexClosure> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ReadIndexClosure.class, "state");
    private static final int PENDING = 0;
    private static final int COMPLETE = 1;
    public static final long INVALID_LOG_INDEX = -1L;
    private long index = -1L;
    private byte[] requestContext;
    private volatile int state = 0;

    public abstract void run(Status var1, long var2, byte[] var4);

    public void setResult(long index, byte[] reqCtx) {
        this.index = index;
        this.requestContext = reqCtx;
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getRequestContext() {
        return this.requestContext;
    }

    @Override
    public void run(Status status) {
        if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
            LOG.warn("A timeout read-index response finally returned: {}.", status);
            return;
        }
        try {
            this.run(status, this.index, this.requestContext);
        }
        catch (Throwable t) {
            LOG.error("Fail to run ReadIndexClosure with status: {}.", t, status);
        }
    }
}

