/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.sorted.comparator;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.SwitchStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite3.internal.binarytuple.BinaryTupleFormatException;
import org.apache.ignite3.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite3.internal.binarytuple.ByteBufferAccessor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.schema.BinaryTupleComparatorUtils;
import org.apache.ignite3.internal.schema.UnsafeByteBufferAccessor;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.comparator.JitComparator;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.comparator.JitComparatorOptions;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.lang.ErrorGroups;

public class JitComparatorGenerator {
    private static final ClassGenerator CLASS_GENERATOR = ClassGenerator.classGenerator(JitComparatorGenerator.class.getClassLoader());
    private static final Method PARSER_BYTE_VALUE;
    private static final Method PARSER_SHORT_VALUE;
    private static final Method PARSER_INT_VALUE;
    private static final Method PARSER_LONG_VALUE;
    private static final Method PARSER_FLOAT_VALUE;
    private static final Method PARSER_DOUBLE_VALUE;
    private static final Method PARSER_DATE_VALUE;
    private static final Method PARSER_TIME_VALUE;
    private static final Method PARSER_DATETIME_VALUE;
    private static final Method BYTE_COMPARE;
    private static final Method SHORT_COMPARE;
    private static final Method INT_COMPARE;
    private static final Method LONG_COMPARE;
    private static final Method FLOAT_COMPARE;
    private static final Method DOUBLE_COMPARE;
    private static final Method UTILS_TIMESTAMP_COMPARE;
    private static final Method UTILS_UUID_COMPARE;
    private static final Method UTILS_STRING_COMPARE;
    private static final Method UTILS_BYTES_COMPARE;
    private static final Method DECIMAL_COMPARE;
    private static final Method LOCAL_DATE_COMPARE_TO;
    private static final Method LOCAL_TIME_COMPARE_TO;
    private static final Method LOCAL_DATETIME_COMPARE_TO;
    private static final AtomicInteger CLASS_NAME_COUNTER;

    public static JitComparator createComparator(JitComparatorOptions options) {
        int maxEntrySizeLog = JitComparatorGenerator.maxEntrySizeLog(options.columnTypes());
        String optionalClassName = options.className();
        String className = optionalClassName != null ? optionalClassName : JitComparator.class.getName() + "Impl$$" + CLASS_NAME_COUNTER.getAndIncrement();
        ClassDefinition classDefinition = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), className.replace('.', '/'), ParameterizedType.type(Object.class), ParameterizedType.type(JitComparator.class));
        MethodDefinition compare = classDefinition.declareMethod(EnumSet.of(Access.PUBLIC, Access.FINAL), "compare", ParameterizedType.type(Integer.TYPE), Parameter.arg("outerAccessor", UnsafeByteBufferAccessor.class), Parameter.arg("outerSize", Integer.TYPE), Parameter.arg("innerAccessor", UnsafeByteBufferAccessor.class), Parameter.arg("innerSize", Integer.TYPE));
        compare.declareAnnotation(Override.class);
        Scope scope = compare.getScope();
        BytecodeBlock body = compare.getBody();
        Variable outerAccessor = scope.getVariable("outerAccessor");
        Variable innerAccessor = scope.getVariable("innerAccessor");
        Variable outerSize = scope.getVariable("outerSize");
        Variable innerSize = scope.getVariable("innerSize");
        Variable outerEntrySize = scope.declareVariable(Integer.TYPE, "outerEntrySize");
        Variable innerEntrySize = scope.declareVariable(Integer.TYPE, "innerEntrySize");
        Variable outerHeader = scope.declareVariable(Byte.TYPE, "outerHeader");
        Variable outerIsPrefix = scope.declareVariable(Boolean.TYPE, "outerIsPrefix");
        if (options.supportPrefixes() || maxEntrySizeLog != 0) {
            body.append(outerHeader.set(outerAccessor.invoke("get", Byte.TYPE, BytecodeExpressions.constantInt(0))));
        }
        if (options.supportPrefixes()) {
            body.append(outerIsPrefix.set(BytecodeExpressions.notEqual(BytecodeExpressions.bitwiseAnd(outerHeader.cast(Integer.TYPE), BytecodeExpressions.constantInt(8)), BytecodeExpressions.constantInt(0))));
        }
        if (maxEntrySizeLog != 0) {
            Variable innerHeader = scope.declareVariable(Byte.TYPE, "innerHeader");
            body.append(innerHeader.set(innerAccessor.invoke("get", Byte.TYPE, BytecodeExpressions.constantInt(0))));
            body.append(outerEntrySize.set(BytecodeExpressions.bitwiseAnd(outerHeader.cast(Integer.TYPE), BytecodeExpressions.constantInt(3))));
            body.append(innerEntrySize.set(BytecodeExpressions.bitwiseAnd(innerHeader.cast(Integer.TYPE), BytecodeExpressions.constantInt(3))));
        }
        MethodDefinition[][] innerCompareMethods = new MethodDefinition[3][3];
        for (int i = 0; i <= maxEntrySizeLog; ++i) {
            for (int j = 0; j <= maxEntrySizeLog; ++j) {
                innerCompareMethods[i][j] = JitComparatorGenerator.innerCompare(classDefinition, options, 1 << i, 1 << j);
            }
        }
        if (maxEntrySizeLog == 0) {
            BytecodeExpression invokeInnerCompare = BytecodeExpressions.invokeStatic(innerCompareMethods[0][0], options.supportPrefixes() ? outerIsPrefix : BytecodeExpressions.constantBoolean(false), outerAccessor, outerSize, innerAccessor, innerSize);
            body.append(invokeInnerCompare.ret());
        } else {
            SwitchStatement.SwitchBuilder outerSwitchBuilder = SwitchStatement.switchBuilder().expression(outerEntrySize).defaultCase(new BytecodeBlock().append(BytecodeExpressions.newInstance(BinaryTupleFormatException.class, BytecodeExpressions.constantString("Invalid header, offset size 8 is not supported."))).throwObject());
            for (int i = 0; i <= maxEntrySizeLog; ++i) {
                SwitchStatement.SwitchBuilder innerSwitchBuilder = SwitchStatement.switchBuilder().expression(innerEntrySize).defaultCase(new BytecodeBlock().append(BytecodeExpressions.newInstance(BinaryTupleFormatException.class, BytecodeExpressions.constantString("Invalid header, offset size 8 is not supported."))).throwObject());
                for (int j = 0; j <= maxEntrySizeLog; ++j) {
                    BytecodeExpression invokeInnerCompare = BytecodeExpressions.invokeStatic(innerCompareMethods[i][j], options.supportPrefixes() ? outerIsPrefix : BytecodeExpressions.constantBoolean(false), outerAccessor, outerSize, innerAccessor, innerSize);
                    innerSwitchBuilder.addCase(j, invokeInnerCompare.ret());
                }
                outerSwitchBuilder.addCase(i, innerSwitchBuilder.build());
            }
            body.append(outerSwitchBuilder.build());
        }
        MethodDefinition constructor = classDefinition.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[0]);
        constructor.getBody().append(VariableInstruction.loadVariable(constructor.getThis())).invokeConstructor(Object.class, new Class[0]).ret();
        Class<Object> clazz = CLASS_GENERATOR.defineClass(classDefinition, Object.class);
        try {
            return (JitComparator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    private static int maxEntrySizeLog(List<NativeType> columnTypes) {
        if (columnTypes.stream().allMatch(NativeType::fixedLength)) {
            int maxTupleColumnsDataSize = columnTypes.stream().mapToInt(NativeType::sizeInBytes).sum();
            if (maxTupleColumnsDataSize < 256) {
                return 0;
            }
            if (maxTupleColumnsDataSize < 65536) {
                return 1;
            }
            return 2;
        }
        return 2;
    }

    private static MethodDefinition innerCompare(ClassDefinition classDefinition, JitComparatorOptions options, int outerEntrySize, int innerEntrySize) {
        MethodDefinition innerCompare = classDefinition.declareMethod(EnumSet.of(Access.PRIVATE, Access.STATIC), "innerCompare" + outerEntrySize + innerEntrySize, ParameterizedType.type(Integer.TYPE), Parameter.arg("outerIsPrefix", Boolean.TYPE), Parameter.arg("outerAccessor", UnsafeByteBufferAccessor.class), Parameter.arg("outerSize", Integer.TYPE), Parameter.arg("innerAccessor", UnsafeByteBufferAccessor.class), Parameter.arg("innerSize", Integer.TYPE));
        BytecodeBlock body = innerCompare.getBody();
        Scope scope = innerCompare.getScope();
        Variable outerIsPrefix = scope.getVariable("outerIsPrefix");
        Variable outerAccessor = scope.getVariable("outerAccessor");
        Variable innerAccessor = scope.getVariable("innerAccessor");
        Variable outerSize = scope.getVariable("outerSize");
        Variable innerSize = scope.getVariable("innerSize");
        Variable outerEntryBaseStart = scope.declareVariable(Integer.TYPE, "outerEntryBaseStart");
        Variable innerEntryBaseStart = scope.declareVariable(Integer.TYPE, "innerEntryBaseStart");
        Variable prefixColumns = scope.declareVariable(Integer.TYPE, "prefixColumns");
        if (options.supportPrefixes()) {
            body.append(new IfStatement().condition(outerIsPrefix).ifTrue(new BytecodeBlock().append(outerSize.set(BytecodeExpressions.subtract(outerSize, BytecodeExpressions.constantInt(4)))).append(prefixColumns.set(outerAccessor.invoke("getInt", Integer.TYPE, outerSize)))).ifFalse(prefixColumns.set(BytecodeExpressions.constantInt(0))));
        }
        int columnsSize = options.columnTypes().size();
        body.append(outerEntryBaseStart.set(BytecodeExpressions.constantInt(1 + outerEntrySize * columnsSize)));
        body.append(innerEntryBaseStart.set(BytecodeExpressions.constantInt(1 + innerEntrySize * columnsSize)));
        if (options.supportPartialComparison()) {
            body.append(new IfStatement().condition(BytecodeExpressions.greaterThan(innerEntryBaseStart, innerSize)).ifTrue(BytecodeExpressions.constantInt(0).ret()));
        }
        Variable cmp = scope.declareVariable(Integer.TYPE, "cmp");
        Variable outerEntryBaseEnd = scope.declareVariable(Integer.TYPE, "outerEntryBaseEnd");
        Variable innerEntryBaseEnd = scope.declareVariable(Integer.TYPE, "innerEntryBaseEnd");
        Variable outerInNull = scope.declareVariable(Boolean.TYPE, "outerInNull");
        Variable innerInNull = scope.declareVariable(Boolean.TYPE, "innerInNull");
        for (int i = 0; i < columnsSize; ++i) {
            boolean lastIteration = i == columnsSize - 1;
            LabelNode endOfBlockLabel = new LabelNode();
            if (lastIteration && !options.supportPartialComparison()) {
                body.append(outerEntryBaseEnd.set(outerSize));
                body.append(innerEntryBaseEnd.set(innerSize));
            } else {
                body.append(outerEntryBaseEnd.set(BytecodeExpressions.add(BytecodeExpressions.constantInt(1 + outerEntrySize * columnsSize), JitComparatorGenerator.getOffset(outerAccessor, outerEntrySize, i))));
                body.append(innerEntryBaseEnd.set(BytecodeExpressions.add(BytecodeExpressions.constantInt(1 + innerEntrySize * columnsSize), JitComparatorGenerator.getOffset(innerAccessor, innerEntrySize, i))));
            }
            CatalogColumnCollation collation = options.columnCollations().get(i);
            NativeType columnType = options.columnTypes().get(i);
            if (options.supportPartialComparison()) {
                body.append(new IfStatement().condition(BytecodeExpressions.greaterThan(innerEntryBaseEnd, innerSize)).ifTrue(JitComparatorGenerator.comparePartialTupleElement(collation, columnType, new ComparisonVariables(outerAccessor, outerEntryBaseStart, outerEntryBaseEnd, innerAccessor, innerEntryBaseStart, innerEntryBaseEnd)).ret()));
            }
            if (options.nullableFlags().get(i).booleanValue()) {
                body.append(outerInNull.set(BytecodeExpressions.equal(outerEntryBaseStart, outerEntryBaseEnd)));
                body.append(innerInNull.set(BytecodeExpressions.equal(innerEntryBaseStart, innerEntryBaseEnd)));
                body.append(new IfStatement().condition(BytecodeExpressions.bitwiseAnd(outerInNull, innerInNull)).ifTrue(lastIteration && !options.supportPrefixes() ? BytecodeExpressions.constantInt(0).ret() : JumpInstruction.jump(endOfBlockLabel)).ifFalse(new IfStatement().condition(BytecodeExpressions.bitwiseOr(outerInNull, innerInNull)).ifTrue(new IfStatement().condition(outerInNull).ifTrue((collation.nullsFirst() ? BytecodeExpressions.constantInt(-1) : BytecodeExpressions.constantInt(1)).ret()).ifFalse((collation.nullsFirst() ? BytecodeExpressions.constantInt(1) : BytecodeExpressions.constantInt(-1)).ret()))));
            }
            BytecodeExpression compareExpression = JitComparatorGenerator.compareTupleElement(collation, columnType, new ComparisonVariables(outerAccessor, outerEntryBaseStart, outerEntryBaseEnd, innerAccessor, innerEntryBaseStart, innerEntryBaseEnd));
            if (lastIteration && !options.supportPrefixes()) {
                body.append(compareExpression.ret());
            } else {
                body.append(cmp.set(compareExpression));
                body.append(new IfStatement().condition(BytecodeExpressions.notEqual(BytecodeExpressions.constantInt(0), cmp)).ifTrue(cmp.ret()));
                body.append(endOfBlockLabel);
                if (!lastIteration) {
                    body.append(outerEntryBaseStart.set(outerEntryBaseEnd));
                    body.append(innerEntryBaseStart.set(innerEntryBaseEnd));
                }
            }
            if (!options.supportPrefixes()) continue;
            BytecodeExpression outerHeaderExpression = outerAccessor.invoke("get", Byte.TYPE, BytecodeExpressions.constantInt(0)).cast(Integer.TYPE);
            body.append(new IfStatement().condition(BytecodeExpressions.and(outerIsPrefix, BytecodeExpressions.equal(BytecodeExpressions.constantInt(i + 1), prefixColumns))).ifTrue(BytecodeExpressions.inlineIf(BytecodeExpressions.equal(BytecodeExpressions.bitwiseAnd(outerHeaderExpression, BytecodeExpressions.constantInt(16)), BytecodeExpressions.constantInt(0)), BytecodeExpressions.constantInt(-1), BytecodeExpressions.constantInt(1)).ret()));
        }
        body.append(BytecodeExpressions.constantInt(0).ret());
        return innerCompare;
    }

    private static BytecodeExpression getOffset(Variable accessor, int entrySizeConstant, int position) {
        switch (entrySizeConstant) {
            case 1: {
                return BytecodeExpressions.invokeStatic(Byte.class, "toUnsignedInt", Integer.TYPE, accessor.invoke("get", Byte.TYPE, BytecodeExpressions.constantInt(1 + position)));
            }
            case 2: {
                return BytecodeExpressions.invokeStatic(Short.class, "toUnsignedInt", Integer.TYPE, accessor.invoke("getShort", Short.TYPE, BytecodeExpressions.constantInt(1 + 2 * position)));
            }
            case 4: {
                return accessor.invoke("getInt", Integer.TYPE, BytecodeExpressions.constantInt(1 + 4 * position));
            }
        }
        throw new IllegalArgumentException("Unsupported entry size constant: " + entrySizeConstant);
    }

    private static BytecodeExpression compareTupleElement(CatalogColumnCollation collation, NativeType nativeType, ComparisonVariables vars) {
        switch (nativeType.spec()) {
            case BOOLEAN: 
            case INT8: {
                return JitComparatorGenerator.compositeStaticCompare(collation, vars, PARSER_BYTE_VALUE, BYTE_COMPARE);
            }
            case INT16: {
                return JitComparatorGenerator.compositeStaticCompare(collation, vars, PARSER_SHORT_VALUE, SHORT_COMPARE);
            }
            case INT32: {
                return JitComparatorGenerator.compositeStaticCompare(collation, vars, PARSER_INT_VALUE, INT_COMPARE);
            }
            case INT64: {
                return JitComparatorGenerator.compositeStaticCompare(collation, vars, PARSER_LONG_VALUE, LONG_COMPARE);
            }
            case FLOAT: {
                return JitComparatorGenerator.compositeStaticCompare(collation, vars, PARSER_FLOAT_VALUE, FLOAT_COMPARE);
            }
            case DOUBLE: {
                return JitComparatorGenerator.compositeStaticCompare(collation, vars, PARSER_DOUBLE_VALUE, DOUBLE_COMPARE);
            }
            case DECIMAL: {
                return JitComparatorGenerator.staticCompare(collation, vars, DECIMAL_COMPARE, true);
            }
            case DATE: {
                return JitComparatorGenerator.compositeVirtualCompare(collation, vars, PARSER_DATE_VALUE, LOCAL_DATE_COMPARE_TO);
            }
            case TIME: {
                return JitComparatorGenerator.compositeVirtualCompare(collation, vars, PARSER_TIME_VALUE, LOCAL_TIME_COMPARE_TO);
            }
            case DATETIME: {
                return JitComparatorGenerator.compositeVirtualCompare(collation, vars, PARSER_DATETIME_VALUE, LOCAL_DATETIME_COMPARE_TO);
            }
            case TIMESTAMP: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_TIMESTAMP_COMPARE, true);
            }
            case UUID: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_UUID_COMPARE, false);
            }
            case STRING: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_STRING_COMPARE, true);
            }
            case BYTE_ARRAY: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_BYTES_COMPARE, true);
            }
        }
        throw new IllegalArgumentException(IgniteStringFormatter.format("Unsupported column type in binary tuple comparator. [type={}]", nativeType));
    }

    private static BytecodeExpression comparePartialTupleElement(CatalogColumnCollation collation, NativeType nativeType, ComparisonVariables vars) {
        switch (nativeType.spec()) {
            case TIMESTAMP: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_TIMESTAMP_COMPARE, true);
            }
            case UUID: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_UUID_COMPARE, false);
            }
            case STRING: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_STRING_COMPARE, true);
            }
            case BYTE_ARRAY: {
                return JitComparatorGenerator.staticCompare(collation, vars, UTILS_BYTES_COMPARE, true);
            }
        }
        return BytecodeExpressions.constantInt(0);
    }

    private static BytecodeExpression compositeStaticCompare(CatalogColumnCollation collation, ComparisonVariables vars, Method extractor, Method comparator) {
        BytecodeExpression outerValue = BytecodeExpressions.invokeStatic(extractor, vars.outerAccessor, vars.outerEntryBaseStart, vars.outerEntryBaseEnd);
        BytecodeExpression innerValue = BytecodeExpressions.invokeStatic(extractor, vars.innerAccessor, vars.innerEntryBaseStart, vars.innerEntryBaseEnd);
        if (collation.asc()) {
            return BytecodeExpressions.invokeStatic(comparator, outerValue, innerValue);
        }
        return BytecodeExpressions.invokeStatic(comparator, innerValue, outerValue);
    }

    private static BytecodeExpression compositeVirtualCompare(CatalogColumnCollation collation, ComparisonVariables vars, Method extractor, Method comparator) {
        BytecodeExpression outerValue = BytecodeExpressions.invokeStatic(extractor, vars.outerAccessor, vars.outerEntryBaseStart, vars.outerEntryBaseEnd);
        BytecodeExpression innerValue = BytecodeExpressions.invokeStatic(extractor, vars.innerAccessor, vars.innerEntryBaseStart, vars.innerEntryBaseEnd);
        if (collation.asc()) {
            return outerValue.invoke(comparator, innerValue);
        }
        return innerValue.invoke(comparator, outerValue);
    }

    private static BytecodeExpression staticCompare(CatalogColumnCollation collation, ComparisonVariables vars, Method comparator, boolean passEnd) {
        if (collation.asc()) {
            if (passEnd) {
                return BytecodeExpressions.invokeStatic(comparator, vars.outerAccessor, vars.outerEntryBaseStart, vars.outerEntryBaseEnd, vars.innerAccessor, vars.innerEntryBaseStart, vars.innerEntryBaseEnd);
            }
            return BytecodeExpressions.invokeStatic(comparator, vars.outerAccessor, vars.outerEntryBaseStart, vars.innerAccessor, vars.innerEntryBaseStart);
        }
        if (passEnd) {
            return BytecodeExpressions.invokeStatic(comparator, vars.innerAccessor, vars.innerEntryBaseStart, vars.innerEntryBaseEnd, vars.outerAccessor, vars.outerEntryBaseStart, vars.outerEntryBaseEnd);
        }
        return BytecodeExpressions.invokeStatic(comparator, vars.innerAccessor, vars.innerEntryBaseStart, vars.outerAccessor, vars.outerEntryBaseStart);
    }

    public static int compareBigDecimal(UnsafeByteBufferAccessor buf1, int begin1, int end1, UnsafeByteBufferAccessor buf2, int begin2, int end2) {
        BigDecimal left = JitComparatorGenerator.decimalValue(buf1, begin1, end1);
        BigDecimal right = JitComparatorGenerator.decimalValue(buf2, begin2, end2);
        return left.compareTo(right);
    }

    private static BigDecimal decimalValue(UnsafeByteBufferAccessor buf, int begin, int end) {
        short scale = BinaryTupleParser.shortValue(buf, begin, begin + 2);
        return new BigDecimal(JitComparatorGenerator.numberValue(buf, begin + 2, end), scale);
    }

    private static BigInteger numberValue(UnsafeByteBufferAccessor buf, int begin, int end) {
        byte[] bytes;
        int len = end - begin;
        if (len <= 0) {
            throw new BinaryTupleFormatException("Invalid length for a tuple element: " + len);
        }
        byte[] array = buf.getArray();
        if (array != null) {
            bytes = array;
            begin += (int)(buf.getAddress() - GridUnsafe.BYTE_ARR_OFF);
        } else {
            bytes = GridUnsafe.getBytes(buf.getAddress(), begin, len);
        }
        return new BigInteger(bytes, begin, len);
    }

    static {
        try {
            PARSER_BYTE_VALUE = BinaryTupleParser.class.getDeclaredMethod("byteValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_SHORT_VALUE = BinaryTupleParser.class.getDeclaredMethod("shortValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_INT_VALUE = BinaryTupleParser.class.getDeclaredMethod("intValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_LONG_VALUE = BinaryTupleParser.class.getDeclaredMethod("longValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_FLOAT_VALUE = BinaryTupleParser.class.getDeclaredMethod("floatValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_DOUBLE_VALUE = BinaryTupleParser.class.getDeclaredMethod("doubleValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_DATE_VALUE = BinaryTupleParser.class.getDeclaredMethod("dateValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_TIME_VALUE = BinaryTupleParser.class.getDeclaredMethod("timeValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            PARSER_DATETIME_VALUE = BinaryTupleParser.class.getDeclaredMethod("dateTimeValue", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            BYTE_COMPARE = Byte.class.getDeclaredMethod("compare", Byte.TYPE, Byte.TYPE);
            SHORT_COMPARE = Short.class.getDeclaredMethod("compare", Short.TYPE, Short.TYPE);
            INT_COMPARE = Integer.class.getDeclaredMethod("compare", Integer.TYPE, Integer.TYPE);
            LONG_COMPARE = Long.class.getDeclaredMethod("compare", Long.TYPE, Long.TYPE);
            FLOAT_COMPARE = Float.class.getDeclaredMethod("compare", Float.TYPE, Float.TYPE);
            DOUBLE_COMPARE = Double.class.getDeclaredMethod("compare", Double.TYPE, Double.TYPE);
            UTILS_TIMESTAMP_COMPARE = BinaryTupleComparatorUtils.class.getDeclaredMethod("compareAsTimestamp", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE, ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            UTILS_UUID_COMPARE = BinaryTupleComparatorUtils.class.getDeclaredMethod("compareAsUuid", ByteBufferAccessor.class, Integer.TYPE, ByteBufferAccessor.class, Integer.TYPE);
            UTILS_STRING_COMPARE = BinaryTupleComparatorUtils.class.getDeclaredMethod("compareAsString", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE, ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            UTILS_BYTES_COMPARE = BinaryTupleComparatorUtils.class.getDeclaredMethod("compareAsBytes", ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE, ByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            DECIMAL_COMPARE = JitComparatorGenerator.class.getDeclaredMethod("compareBigDecimal", UnsafeByteBufferAccessor.class, Integer.TYPE, Integer.TYPE, UnsafeByteBufferAccessor.class, Integer.TYPE, Integer.TYPE);
            LOCAL_DATE_COMPARE_TO = LocalDate.class.getDeclaredMethod("compareTo", ChronoLocalDate.class);
            LOCAL_TIME_COMPARE_TO = LocalTime.class.getDeclaredMethod("compareTo", LocalTime.class);
            LOCAL_DATETIME_COMPARE_TO = LocalDateTime.class.getDeclaredMethod("compareTo", ChronoLocalDateTime.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        CLASS_NAME_COUNTER = new AtomicInteger();
    }

    private static class ComparisonVariables {
        final Variable outerAccessor;
        final Variable outerEntryBaseStart;
        final Variable outerEntryBaseEnd;
        final Variable innerAccessor;
        final Variable innerEntryBaseStart;
        final Variable innerEntryBaseEnd;

        ComparisonVariables(Variable outerAccessor, Variable outerEntryBaseStart, Variable outerEntryBaseEnd, Variable innerAccessor, Variable innerEntryBaseStart, Variable innerEntryBaseEnd) {
            this.outerAccessor = outerAccessor;
            this.outerEntryBaseStart = outerEntryBaseStart;
            this.outerEntryBaseEnd = outerEntryBaseEnd;
            this.innerAccessor = innerAccessor;
            this.innerEntryBaseStart = innerEntryBaseStart;
            this.innerEntryBaseEnd = innerEntryBaseEnd;
        }
    }
}

