/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.scalecube;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.cluster.metadata.MetadataCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.AbstractTopologyService;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.network.DuplicateConsistentIdException;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.TopologyEventHandler;
import org.apache.ignite3.network.NetworkAddress;
import org.apache.ignite3.network.NodeMetadata;
import org.jetbrains.annotations.Nullable;

final class ScaleCubeTopologyService
extends AbstractTopologyService {
    private static final IgniteLogger LOG = Loggers.forClass(ScaleCubeTopologyService.class);
    private static final MetadataCodec METADATA_CODEC = MetadataCodec.INSTANCE;
    private volatile Cluster cluster;
    private final ConcurrentMap<NetworkAddress, InternalClusterNode> members = new ConcurrentHashMap<NetworkAddress, InternalClusterNode>();
    private final ConcurrentMap<String, Map<UUID, InternalClusterNode>> membersByConsistentId = new ConcurrentHashMap<String, Map<UUID, InternalClusterNode>>();
    private final ConcurrentMap<String, InternalClusterNode> membersByConsistentIdInLogicalTopology = new ConcurrentHashMap<String, InternalClusterNode>();
    private final ConcurrentMap<UUID, InternalClusterNode> idToMemberMap = new ConcurrentHashMap<UUID, InternalClusterNode>();

    ScaleCubeTopologyService() {
    }

    void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    void onMembershipEvent(MembershipEvent event) {
        NodeMetadata metadata = ScaleCubeTopologyService.deserializeMetadata(event.newMetadata());
        InternalClusterNode member = ScaleCubeTopologyService.fromMember(event.member(), metadata);
        if (event.isAdded()) {
            this.onAddedEvent(member);
        } else if (event.isUpdated()) {
            this.onUpdatedEvent(member);
        } else if (event.isRemoved() || event.isLeaving()) {
            this.onRemovedOrLeftEvent(event, member);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Topology snapshot [nodes={}]", this.members.values().stream().map(InternalClusterNode::name).collect(Collectors.toList()));
        }
    }

    private void onAddedEvent(InternalClusterNode member) {
        @Nullable InternalClusterNode differentNodeWithSameAddress = this.replaceMemberByAddress(member);
        this.replaceMemberByConsistentId(member, differentNodeWithSameAddress);
        this.replaceMemberById(member, differentNodeWithSameAddress);
        LOG.info("Node joined [node={}]", member);
        this.fireAppearedEvent(member);
    }

    @Nullable
    private InternalClusterNode replaceMemberByAddress(InternalClusterNode member) {
        InternalClusterNode prevNodeWithSameAddress = this.members.put(member.address(), member);
        return prevNodeWithSameAddress == null || prevNodeWithSameAddress.id().equals(member.id()) ? null : prevNodeWithSameAddress;
    }

    private void replaceMemberByConsistentId(InternalClusterNode member, @Nullable InternalClusterNode differentNodeWithSameAddress) {
        this.membersByConsistentId.compute(member.name(), (name, nodesWithGivenConsistentId) -> {
            if (nodesWithGivenConsistentId == null) {
                nodesWithGivenConsistentId = new ConcurrentHashMap<UUID, InternalClusterNode>();
            }
            if (differentNodeWithSameAddress != null) {
                nodesWithGivenConsistentId.remove(differentNodeWithSameAddress.id());
            }
            nodesWithGivenConsistentId.put(member.id(), member);
            return nodesWithGivenConsistentId;
        });
    }

    private void replaceMemberById(InternalClusterNode member, @Nullable InternalClusterNode differentNodeWithSameAddress) {
        this.idToMemberMap.put(member.id(), member);
        if (differentNodeWithSameAddress != null) {
            this.idToMemberMap.remove(differentNodeWithSameAddress.id());
        }
    }

    private void onUpdatedEvent(InternalClusterNode member) {
        @Nullable InternalClusterNode differentNodeWithSameAddress = this.replaceMemberByAddress(member);
        this.replaceMemberByConsistentId(member, differentNodeWithSameAddress);
        this.membersByConsistentIdInLogicalTopology.compute(member.name(), (consId, existingNode) -> {
            if (existingNode != null && existingNode.id().equals(member.id())) {
                return member;
            }
            return existingNode;
        });
        this.replaceMemberById(member, differentNodeWithSameAddress);
    }

    private void onRemovedOrLeftEvent(MembershipEvent event, InternalClusterNode member) {
        this.members.compute(member.address(), (addr, node) -> {
            if (node == null || node.id().equals(member.id())) {
                LOG.info("Node left [member={}, eventType={}]", member, event.type());
                return null;
            }
            LOG.info("Node left (noop as it has already reappeared) [member={}, eventType={}]", member, event.type());
            return node;
        });
        this.membersByConsistentId.compute(member.name(), (consId, nodes) -> {
            if (nodes != null) {
                nodes.remove(member.id());
                if (nodes.isEmpty()) {
                    return null;
                }
            }
            return nodes;
        });
        this.membersByConsistentIdInLogicalTopology.compute(member.name(), (consId, existingNode) -> {
            if (existingNode != null && existingNode.id().equals(member.id())) {
                return null;
            }
            return existingNode;
        });
        this.idToMemberMap.remove(member.id());
        this.fireDisappearedEvent(member);
    }

    void updateLocalMetadata(@Nullable NodeMetadata metadata) {
        InternalClusterNode node = ScaleCubeTopologyService.fromMember(this.cluster.member(), metadata);
        this.onUpdatedEvent(node);
    }

    private void fireAppearedEvent(InternalClusterNode member) {
        for (TopologyEventHandler handler : this.getEventHandlers()) {
            handler.onAppeared(member);
        }
    }

    private void fireDisappearedEvent(InternalClusterNode member) {
        for (TopologyEventHandler handler : this.getEventHandlers()) {
            handler.onDisappeared(member);
        }
    }

    @Override
    public InternalClusterNode localMember() {
        Member localMember = this.cluster.member();
        NodeMetadata nodeMetadata = this.cluster.metadata().orElse(null);
        assert (localMember != null) : "Cluster has not been started";
        return ScaleCubeTopologyService.fromMember(localMember, nodeMetadata);
    }

    @Override
    public Collection<InternalClusterNode> allMembers() {
        return Collections.unmodifiableCollection(this.members.values());
    }

    @Override
    public Collection<InternalClusterNode> logicalTopologyMembers() {
        ArrayList<InternalClusterNode> res = new ArrayList<InternalClusterNode>(this.membersByConsistentIdInLogicalTopology.size());
        for (InternalClusterNode node : this.members.values()) {
            if (!this.membersByConsistentIdInLogicalTopology.containsKey(node.name())) continue;
            res.add(node);
        }
        return res;
    }

    @Override
    public InternalClusterNode getByAddress(NetworkAddress addr) {
        return (InternalClusterNode)this.members.get(addr);
    }

    @Override
    @Nullable
    public InternalClusterNode getByConsistentId(String consistentId) {
        InternalClusterNode node;
        InternalClusterNode nodeInLogicalTopology = (InternalClusterNode)this.membersByConsistentIdInLogicalTopology.get(consistentId);
        if (nodeInLogicalTopology != null && (node = (InternalClusterNode)this.idToMemberMap.get(nodeInLogicalTopology.id())) != null) {
            return node;
        }
        Map nodes = (Map)this.membersByConsistentId.get(consistentId);
        if (nodes == null) {
            return null;
        }
        if (nodes.size() > 1) {
            LOG.error("Node \"{}\" has duplicate(s) in the physical topology: {}", consistentId, nodes.values().stream().map(InternalClusterNode::address).collect(Collectors.toList()));
            throw new DuplicateConsistentIdException(consistentId);
        }
        try {
            return (InternalClusterNode)nodes.values().iterator().next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public InternalClusterNode getById(UUID id) {
        return (InternalClusterNode)this.idToMemberMap.get(id);
    }

    private static InternalClusterNode fromMember(Member member, @Nullable NodeMetadata nodeMetadata) {
        NetworkAddress addr = new NetworkAddress(member.address().host(), member.address().port());
        return new ClusterNodeImpl(UUID.fromString(member.id()), member.alias(), addr, nodeMetadata);
    }

    @Nullable
    private static NodeMetadata deserializeMetadata(@Nullable ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        try {
            return (NodeMetadata)METADATA_CODEC.deserialize(buffer);
        }
        catch (Exception e) {
            LOG.warn("Couldn't deserialize metadata: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public void onJoined(InternalClusterNode node) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node joined logical topology [node={}]", node);
        }
        this.membersByConsistentIdInLogicalTopology.put(node.name(), node);
    }

    @Override
    public void onLeft(InternalClusterNode node) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node left logical topology [node={}]", node);
        }
        this.membersByConsistentIdInLogicalTopology.remove(node.name());
    }
}

