/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.validation;

import org.apache.ignite3.configuration.validation.NotBlank;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.util.StringUtils;

public class NotBlankValidator
implements Validator<NotBlank, String> {
    @Override
    public void validate(NotBlank annotation, ValidationContext<String> ctx) {
        String value = ctx.getNewValue();
        if (StringUtils.nullOrBlank(value)) {
            String message = "'" + ctx.currentKey() + "' configuration value must not be blank.";
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
    }
}

