/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.validation;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.ignite3.configuration.validation.Endpoint;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;

public class EndpointValidator
implements Validator<Endpoint, String> {
    @Override
    public void validate(Endpoint annotation, ValidationContext<String> ctx) {
        String endpoint = ctx.getNewValue();
        try {
            URL endpointUrl = new URL(endpoint);
            if (!"http".equalsIgnoreCase(endpointUrl.getProtocol()) && !"https".equalsIgnoreCase(endpointUrl.getProtocol())) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Endpoint scheme must be http or https: " + endpointUrl.getProtocol()));
            }
            if (endpointUrl.getQuery() != null) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Endpoint must not have a query string: " + endpointUrl.getQuery()));
            }
            if (endpointUrl.getRef() != null) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Endpoint must not have a fragment: " + endpointUrl.getRef()));
            }
        }
        catch (MalformedURLException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Endpoint must be a valid URL: " + endpoint));
        }
    }
}

