/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.table.IgniteTables;

public class ClientTableGetRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTables tables) {
        String tableName = in.unpackString();
        return tables.tableAsync(tableName).thenApply(table -> out -> {
            if (table == null) {
                out.packNil();
            } else {
                out.packInt(((TableViewInternal)table).tableId());
                out.packString(ClientTableGetRequest.quoteTableNameIfNotAllUpper(table.qualifiedName().objectName()));
            }
        });
    }

    private static String quoteTableNameIfNotAllUpper(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch) || ch == '_' || Character.isUpperCase(ch)) continue;
            return IgniteNameUtils.quoteIfNeeded(name);
        }
        return name;
    }
}

