/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequestSerializer;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReadOnlyScanRetrieveBatchReplicaRequestImpl
implements ReadOnlyScanRetrieveBatchReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 9;
    @IgniteToStringInclude
    private final int batchSize;
    @IgniteToStringInclude
    private final BitSet columnsToInclude;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final BinaryTupleMessage exactKey;
    @IgniteToStringInclude
    private final int flags;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final Integer indexToUse;
    @IgniteToStringInclude
    private final BinaryTupleMessage lowerBoundPrefix;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;
    @IgniteToStringInclude
    private final BinaryTupleMessage upperBoundPrefix;

    private ReadOnlyScanRetrieveBatchReplicaRequestImpl(int batchSize, BitSet columnsToInclude, UUID coordinatorId, BinaryTupleMessage exactKey, int flags, ReplicationGroupIdMessage groupId, Integer indexToUse, BinaryTupleMessage lowerBoundPrefix, HybridTimestamp readTimestamp, long scanId, int tableId, HybridTimestamp timestamp, UUID transactionId, BinaryTupleMessage upperBoundPrefix) {
        this.batchSize = batchSize;
        this.columnsToInclude = columnsToInclude;
        this.coordinatorId = coordinatorId;
        this.exactKey = exactKey;
        this.flags = flags;
        this.groupId = groupId;
        this.indexToUse = indexToUse;
        this.lowerBoundPrefix = lowerBoundPrefix;
        this.readTimestamp = readTimestamp;
        this.scanId = scanId;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        this.upperBoundPrefix = upperBoundPrefix;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public BitSet columnsToInclude() {
        return this.columnsToInclude;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    @Override
    public BinaryTupleMessage exactKey() {
        return this.exactKey;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public Integer indexToUse() {
        return this.indexToUse;
    }

    @Override
    public BinaryTupleMessage lowerBoundPrefix() {
        return this.lowerBoundPrefix;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    public int tableId() {
        return this.tableId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    @Override
    public BinaryTupleMessage upperBoundPrefix() {
        return this.upperBoundPrefix;
    }

    public MessageSerializer serializer() {
        return ReadOnlyScanRetrieveBatchReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyScanRetrieveBatchReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 9;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyScanRetrieveBatchReplicaRequestImpl otherMessage = (ReadOnlyScanRetrieveBatchReplicaRequestImpl)other;
        return Objects.equals(this.columnsToInclude, otherMessage.columnsToInclude) && Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.exactKey, otherMessage.exactKey) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.indexToUse, otherMessage.indexToUse) && Objects.equals(this.lowerBoundPrefix, otherMessage.lowerBoundPrefix) && Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && Objects.equals(this.upperBoundPrefix, otherMessage.upperBoundPrefix) && this.batchSize == otherMessage.batchSize && this.flags == otherMessage.flags && this.scanId == otherMessage.scanId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSize, this.flags, this.scanId, this.tableId, this.columnsToInclude, this.coordinatorId, this.exactKey, this.groupId, this.indexToUse, this.lowerBoundPrefix, this.readTimestamp, this.timestamp, this.transactionId, this.upperBoundPrefix);
        return result;
    }

    public ReadOnlyScanRetrieveBatchReplicaRequestImpl clone() {
        try {
            return (ReadOnlyScanRetrieveBatchReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyScanRetrieveBatchReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.exactKey != null) {
            this.exactKey.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.lowerBoundPrefix != null) {
            this.lowerBoundPrefix.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.upperBoundPrefix != null) {
            this.upperBoundPrefix.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.exactKey != null) {
            this.exactKey.unmarshal(marshaller, descriptorsObj);
        }
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.lowerBoundPrefix != null) {
            this.lowerBoundPrefix.unmarshal(marshaller, descriptorsObj);
        }
        if (this.upperBoundPrefix != null) {
            this.upperBoundPrefix.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlyScanRetrieveBatchReplicaRequestBuilder {
        private int batchSize;
        private BitSet columnsToInclude;
        private UUID coordinatorId;
        private BinaryTupleMessage exactKey;
        private int flags;
        private ReplicationGroupIdMessage groupId;
        private Integer indexToUse;
        private BinaryTupleMessage lowerBoundPrefix;
        private HybridTimestamp readTimestamp;
        private long scanId;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;
        private BinaryTupleMessage upperBoundPrefix;

        private Builder() {
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder columnsToInclude(BitSet columnsToInclude) {
            this.columnsToInclude = columnsToInclude;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder coordinatorId(UUID coordinatorId) {
            Objects.requireNonNull(coordinatorId, "coordinatorId is not marked @Nullable");
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder exactKey(BinaryTupleMessage exactKey) {
            this.exactKey = exactKey;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder flags(int flags) {
            this.flags = flags;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder indexToUse(Integer indexToUse) {
            this.indexToUse = indexToUse;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder lowerBoundPrefix(BinaryTupleMessage lowerBoundPrefix) {
            this.lowerBoundPrefix = lowerBoundPrefix;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder transactionId(UUID transactionId) {
            Objects.requireNonNull(transactionId, "transactionId is not marked @Nullable");
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequestBuilder upperBoundPrefix(BinaryTupleMessage upperBoundPrefix) {
            this.upperBoundPrefix = upperBoundPrefix;
            return this;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public BitSet columnsToInclude() {
            return this.columnsToInclude;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public BinaryTupleMessage exactKey() {
            return this.exactKey;
        }

        @Override
        public int flags() {
            return this.flags;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public Integer indexToUse() {
            return this.indexToUse;
        }

        @Override
        public BinaryTupleMessage lowerBoundPrefix() {
            return this.lowerBoundPrefix;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public BinaryTupleMessage upperBoundPrefix() {
            return this.upperBoundPrefix;
        }

        @Override
        public ReadOnlyScanRetrieveBatchReplicaRequest build() {
            return new ReadOnlyScanRetrieveBatchReplicaRequestImpl(this.batchSize, this.columnsToInclude, Objects.requireNonNull(this.coordinatorId, "coordinatorId is not marked @Nullable"), this.exactKey, this.flags, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.indexToUse, this.lowerBoundPrefix, Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), this.scanId, this.tableId, this.timestamp, Objects.requireNonNull(this.transactionId, "transactionId is not marked @Nullable"), this.upperBoundPrefix);
        }
    }
}

